/**
  Copyright 2011 Viera K. Proulx
 */

import tester.*;

import net.java.quickcheck.*;
import net.java.quickcheck.generator.*;

import net.java.quickcheck.generator.iterable.Iterables;
import net.java.quickcheck.generator.support.*;

import java.util.*;

/*
  +--------+
  | CartPt |
  +--------+
  | int x  |
  | int y  |
  +--------+

 */

class CartPtGenerator implements net.java.quickcheck.Generator<CartPt>{
  
  Generator<Integer> horizontal; 
  Generator<Integer> vertical; 

  CartPtGenerator(){
    this(400, 200);
  }
  
  CartPtGenerator(int w, int h){
    this.horizontal = new IntegerGenerator(0, w);
    this.vertical = new IntegerGenerator(0, h);
  }

  @Override public CartPt next() {
    return new CartPt(horizontal.next(), vertical.next());
  }  
}

class CircleGenerator implements net.java.quickcheck.Generator<Circle>{
  
  Generator<CartPt> center = new CartPtGenerator(300, 200);
  Generator<Integer> radius = new IntegerGenerator(5, 50);
  Collection<String> colors = Arrays.asList("red", "blue", "green", "white", "yellow", "black");
  Generator<String> color = new EnsuredValuesGenerator<String>(this.colors);

  @Override public Circle next() {
    return new Circle(center.next(), color.next(), radius.next());
  }  
}

class SquareGenerator implements net.java.quickcheck.Generator<Square>{
  
  Generator<CartPt> nw = new CartPtGenerator(300, 200);
  Generator<Integer> width = new IntegerGenerator(0, 400);
  Collection<String> colors = Arrays.asList("red", "blue", "green", "white", "yellow", "black");
  Generator<String> color = new EnsuredValuesGenerator<String>(this.colors);

  @Override public Square next() {
    return new Square(nw.next(), color.next(), width.next());
  }  
}

class IShapeGenerator implements net.java.quickcheck.Generator<IShape>{
  
  Generator<Circle> circlegen = new CircleGenerator();
  Generator<Square> squaregen = new SquareGenerator();
  Generator<Boolean> pickgen = PrimitiveGenerators.booleans();

  @Override public IShape next() {
    if (pickgen.next())
      return circlegen.next();
    else
      return squaregen.next();
  }  
}