import tester.*;
import net.java.quickcheck.*;
import net.java.quickcheck.generator.*;

import net.java.quickcheck.generator.iterable.Iterables;
import net.java.quickcheck.generator.support.*;
import java.util.*;

class PersonPet {
  private String first;
  private String last;
  public Pet pet;
 
  public PersonPet(String first, String last, Pet pet) {
    this.first = first;
    this.last = last;
    this.pet = pet;
  }
  
  public String getLast() { return last; }
  public String getFirst() { return first; }
  
  /*
  public boolean equals(Object o){
    Person p = (Person)o;
    return p.first.equals(this.first) &&
           p.last.equals(this.last);
  }
  
  
  public int hashCode(){
    return this.first.hashCode() * this.last.hashCode();
  }
  */
  
  public String petName(){
    return this.pet.getName();
  }
}

class Pet{
  private String name;
  public String kind;
  
  public Pet(String name, String kind){
    this.name = name;
    this.kind = kind;
  }
  
  public String getName(){
    return this.name;
  }
  
}
 
class PersonPetGenerator implements net.java.quickcheck.Generator<PersonPet>{
  Collection<String> petkinds = Arrays.asList("cat", "dog", "gerbil");
  Generator<String> first = PrimitiveGenerators.strings();
  Generator<String> last = PrimitiveGenerators.strings();
  Generator<String> petname = PrimitiveGenerators.strings();
  Generator<String> petkind = new EnsuredValuesGenerator<String>(this.petkinds);
 
  @Override public PersonPet next() {
    return new PersonPet(first.next(), last.next(), new Pet(petname.next(), petkind.next()));
  }
}

class ExamplesPersonPet{
  ExamplesPersonPet(){}
  
  public void testPerson(Tester t){
    System.out.println("Starting at 0");
    int i = 0;
    for(PersonPet name : Iterables.toIterable(new PersonPetGenerator())){
      System.out.println(i + ":    " + name.getFirst() + " ... " + name.getLast() + 
          ": pet name " + name.pet.getName() + " " + name.pet.kind);
      t.checkExpect(name, 
          new PersonPet(name.getFirst(), name.getLast(), 
                        new Pet(name.pet.getName(), name.pet.kind)));
      i++;
    }
  }
  
  public static void main(String[] argv){
    ExamplesPersonPet e = new ExamplesPersonPet();
    Tester.runReport(e, true, true);
  }
}


