import tester.*;
import net.java.quickcheck.*;
import net.java.quickcheck.generator.*;

import net.java.quickcheck.generator.iterable.Iterables;

// a class to represent person's name
class Person {
  private String first;
  private String last;
 
  public Person(String first, String last) {
    this.first = first;
    this.last = last;
  }
  
  public String getLast() { return last; }
  public String getFirst() { return first; }
  
  /*
  public boolean equals(Object o){
    Person p = (Person)o;
    return p.first.equals(this.first) &&
           p.last.equals(this.last);
  }
  
  
  public int hashCode(){
    return this.first.hashCode() * this.last.hashCode();
  }
  */
}

// the class that generates random instances of the Person class
class PersonGenerator implements net.java.quickcheck.Generator<Person>{
  Generator<String> name = PrimitiveGenerators.strings();
 
  @Override public Person next() {
    return new Person(name.next(), name.next());
  }
}

// randomized tests for the class person, using PersonGenerator
class Examples{
  Examples(){}
  
  public void testPerson(Tester t){
    System.out.println("Starting at 0");
    int i = 0;
    for(Person name : Iterables.toIterable(new PersonGenerator())){
      System.out.println(i + ":    " + name.getFirst() + " ... " + name.getLast());
      t.checkExpect(name, new Person(name.getFirst(), name.getLast()));
      i++;
    }
  }
  
  public static void main(String[] argv){
    Examples e = new Examples();
    Tester.runReport(e, true, true);
  }
}


