import net.java.quickcheck.generator.iterable.Iterables;
import tester.Tester;

class ExamplesShapes {
  ExamplesShapes() {}

  CartPt pt1 = new CartPt(0, 0);
  CartPt pt2 = new CartPt(3, 4);
  CartPt pt3 = new CartPt(7, 1);

  IShape c1 = new Circle(new CartPt(50, 50), "red", 10);
  IShape c2 = new Circle(new CartPt(50, 50), "red", 30);
  IShape c3 = new Circle(new CartPt(30, 100), "blue", 30);

  IShape s1 = new Square(new CartPt(50, 50), "red", 30);
  IShape s2 = new Square(new CartPt(50, 50), "red", 50);
  IShape s3 = new Square(new CartPt(20, 40), "green", 10);

  // test the method distTo0 in the class CartPt
  boolean testDistTo0(Tester t){
    return
    t.checkInexact(this.pt1.distTo0(), 0.0, 0.001) &&
    t.checkInexact(this.pt2.distTo0(), 5.0, 0.001);
  }
 
  /*
  public void testQuickDistTo0(Tester t){
    //System.out.println("Starting at 0");
    int i = 0;
    for(CartPt pt : Iterables.toIterable(new CartPtGenerator())){
      double dist = Math.sqrt(pt.x * pt.x + pt.y * pt.y);
      //System.out.println(i + ":    (" + pt.x + ", " + pt.y + 
      //   ")  expect: " + dist);
      t.checkInexact(pt.distTo0(), dist, 0.001);
      i++;
    }
  }
  */

  // test the method distTo in the class CartPt
  boolean testDistTo(Tester t){
    return
    t.checkInexact(this.pt1.distTo(this.pt2), 5.0, 0.001) &&
    t.checkInexact(this.pt2.distTo(this.pt3), 5.0, 0.001);
  }
 
  /*
  public void testQuickDistTo(Tester t){
    //System.out.println("Starting at 0");
    int i = 0;
    CartPtGenerator cartptgen = new CartPtGenerator();
    for(i = 0; i < 200; i++){
        CartPt pt1 = cartptgen.next();
        CartPt pt2 = cartptgen.next();
      double dist = Math.sqrt((pt1.x - pt2.x) * (pt1.x - pt2.x) + 
                              (pt1.y - pt2.y) * (pt1.y - pt2.y));
      //System.out.println(i + ":    (" + pt1.x + ", " + pt1.y + ") to (" +
      //                                + pt2.x + ", " + pt2.y + ")  expect: " 
      //                   + dist);
      t.checkInexact(pt1.distTo(pt2), dist, 0.001);
      t.checkInexact(pt2.distTo(pt1), dist, 0.001);
    }
  }
  */
  
  public void testQuickMoveCartPt(Tester t){
    int i = 0;
    CartPtGenerator cartptgen = new CartPtGenerator();
    for(i = 0; i < 200; i++){
      CartPt pt1 = cartptgen.next();
      CartPt pt1dym1 = new CartPt(pt1.x, pt1.y - 1);
      CartPt pt1dyp1 = new CartPt(pt1.x, pt1.y + 1);
      CartPt pt1dxm1 = new CartPt(pt1.x - 1, pt1.y);
      CartPt pt1dxp1 = new CartPt(pt1.x + 1, pt1.y);
      CartPt pt1dxm1dym1 = new CartPt(pt1.x - 1, pt1.y - 1);
      CartPt pt1dxp1dym1 = new CartPt(pt1.x + 1, pt1.y - 1);
      CartPt pt1dxm1dyp1 = new CartPt(pt1.x - 1, pt1.y + 1);
      CartPt pt1dxp1dyp1 = new CartPt(pt1.x + 1, pt1.y + 1);
      t.checkOneOf(pt1.moveRandom(),
          pt1, 
          pt1dym1, pt1dyp1, 
          pt1dxm1, pt1dxp1, 
          pt1dxm1dym1, pt1dxp1dym1, 
          pt1dxm1dyp1, pt1dxp1dyp1);
          
    }
    
  }

  // test the method area in the class Circle
  boolean testCircleArea(Tester t){
    return
    t.checkInexact(this.c1.area(), 314.15, 0.01);
  }
 
  /*
  public void testQuickCircleArea(Tester t){
    //System.out.println("Starting at 0");
    int i = 0;
    CircleGenerator circlegen = new CircleGenerator();
    for(i = 0; i < 200; i++){
        Circle cir = circlegen.next();
      double area = Math.PI * (cir.radius * cir.radius);
      
      t.checkInexact(cir.area(), area, 0.001);
    }
  }
*/
  
  // test the method grow in the class Circle
  boolean testSquareArea(Tester t){
    return
    t.checkInexact(this.s1.area(), 900.0, 0.01);
  }

  // test the method distTo0 in the class Circle
  boolean testCircleDistTo0(Tester t){
    return
    t.checkInexact(this.c1.distTo0(), 60.71, 0.01) &&
    t.checkInexact(this.c3.distTo0(), 74.40, 0.01);
  }

  // test the methdod distTo in the class Circle
  boolean testSquareDistTo0(Tester t){
    return
    t.checkInexact(this.s1.distTo0(), 70.71, 0.01) &&
    t.checkInexact(this.s3.distTo0(), 44.72, 0.01);
  }

  // test the method biggerThan in the class Circle
  boolean testCircleBiggerThan(Tester t){
    return
    t.checkExpect(this.c1.biggerThan(this.c2), false) &&
    t.checkExpect(this.c2.biggerThan(this.c1), true) &&
    t.checkExpect(this.c1.biggerThan(this.s1), false) &&
    t.checkExpect(this.c1.biggerThan(this.s3), true);
  }

  // test the method biggerThan in the class Square
  boolean testSquareBiggerThan(Tester t){
    return
    t.checkExpect(this.s1.biggerThan(this.s2), false) &&
    t.checkExpect(this.s2.biggerThan(this.s1), true) &&
    t.checkExpect(this.s1.biggerThan(this.c1), true) &&
    t.checkExpect(this.s3.biggerThan(this.c1), false);
  }
  
  
  // run the program/tests directly
  public static void main(String[] argv){
    ExamplesShapes e = new ExamplesShapes();
    Tester.runReport(e, true, false);
  }
}
