import java.awt.image.*;
import java.io.*;

import javax.imageio.ImageIO;
import java.awt.Color;

/**
 * This class allows the user to set individual pixels 
 * for an image of the given height and width to the desired
 * RGB color and to save the resulting image as a .png file
 * 
 * @author Viera K. Proulx
 * @since 8 April 2010
 */
public class ImageReader{
	int width;
	int height;
    
	File inputfile;
	
	/** the buffer that saves the user-generated image */
	BufferedImage image;
	
	ColorModel cmodel;
	
	ImageReader(String filename){
		
		/** now we set up the image file for the user to process */
		try{
			this.inputfile = new File(filename);
			this.image =ImageIO.read(this.inputfile);
			this.width = this.image.getWidth();
			this.height = this.image.getHeight();
			this.cmodel = this.image.getColorModel();
		}
		catch(IOException e){
			System.out.println("Could not open the file");
		}
	}
	
	/**
	 * Get the specified pixel in the <code>image</code>
	 * to the given RGB color.
	 * 
	 * @param x the x coordinate of the pixel
	 * @param y the y coordinate of the pixel
	 * @param r the red shade value of the pixel
	 * @param g the green shade value of the pixel
	 * @param b the blue shade value of the pixel
	 */
	public Color getColorPixel(int x, int y){ 
		int pixel = this.image.getRGB(x, y);
		return new Color(pixel);
	}
	
}