import java.awt.Color;
import java.io.IOException;

import tester.Tester;

/**
 * An example of how one can use the two ImageReader classes and the MarsFileReader
 * to read images and build new images using the ImageBuilder class
 */
class ExamplesImages{
	
	ExamplesImages(){}
	
	// read an image file, 
	// test that reading and writing works correctly
	void testImages(Tester t){
		ImageReader ir = new ImageReader("Flowers.png");
		ImageBuilder2 iwred = new ImageBuilder2(ir.width, ir.height);
		Color c = ir.getColorPixel(20, 30);
		iwred.setColorPixel(20, 30, 
							c.getRed(), 0, 0);
		t.checkExpect(iwred.getColorPixel(20, 30),
					  new Color(c.getRed(), 0, 0));
	}
	
	// read the mars file
	// test that reading and writing works correctly
	void testMarsImages(Tester t){
		MarsFileReader mr = new MarsFileReader();
		ImageBuilder2 mw = new ImageBuilder2(20, 30);
		int shade = 0; // the last shade that was set
		try{
			
			// read 10 pixels in a row for five rows
			for (int x = 0; x < 10; x = x + 1){
				for (int y = 0; y < 5; y = y + 1){
					
					// read the next shade
					shade = mr.bytestream.read();
					
					// set the pixel in our image 
					// to the same shade of gray
					mw.setColorPixel(x, y, 
									 shade, shade, shade);
				}
			}
			
			// check that the last pixel has been set correctly
			t.checkExpect(mw.getColorPixel(9, 4),
						  new Color(shade, shade, shade));
			
			// show the Canvas
			mw.canvas.show();
		}
		catch(IOException e){
			System.out.println("Error in reading Mars file");
		}
	}
}