import java.util.*;
import tester.*;

/** Class to hold examples of data and tests */
public class ExamplesWords{

    public ExamplesWords() {}
    
    /** Test Word Classes... */
    public void testWords(Tester t){      	
        
        t.checkExpect(new Word("hey").equals(new Word("hey")), true);
        t.checkExpect(new Word("hey").equals(new Word("you")), false);

        WordCounter wc = new WordCounter();
        wc.countWords(new StringIterator(new StringBuffer("The Words Are")));
        t.checkExpect(wc.words(), 3);
        
        WordCounter macbeth = new WordCounter();
        macbeth.countWords(new StringIterator("Macbeth.txt"));
        macbeth.printWords(10);
    }

    public void testStringIter(Tester t){
        StringIterator wrds = new StringIterator(new StringBuffer("The Words Are"));
        
        int i = 0;
        for(Word w : wrds){
            System.out.println(" Word["+ (i++) +"] : "+w);
        }
    }
}