import tester.*;  

// Test the use of function objects with lists of ImageFile-s
public class ExamplesImageFile{
  ExamplesImageFile(){}

  // sample data to be used for all tests
  public ImageFile pic1 = new ImageFile("dog", 300, 200, "jpg");
  public ImageFile pic2 = new ImageFile("cat", 200, 200, "png");
  public ImageFile pic3 = new ImageFile("bird", 250, 200, "jpg");
  public ImageFile pic4 = new ImageFile("horse", 300, 300, "giff");
  public ImageFile pic5 = new ImageFile("goat", 100, 200, "giff");
  public ImageFile pic6 = new ImageFile("cow", 150, 200, "jpg");
  public ImageFile pic7 = new ImageFile("snake", 200, 300, "jpg");

  //empty list
  public ILo<ImageFile> mt= new MtLo<ImageFile>();

  // picture list -- all pictures
  public ILo<ImageFile> piclistall = 
    new ConsLo<ImageFile>(this.pic1, 
        new ConsLo<ImageFile>(this.pic2,
            new ConsLo<ImageFile>(this.pic3, 
                new ConsLo<ImageFile>(this.pic4, 
                    new ConsLo<ImageFile>(this.pic5, 
                        new ConsLo<ImageFile>(this.pic6, 
                            new ConsLo<ImageFile>(this.pic7, this.mt))))))); 

  // picture list - short names (less than 4 characters)
  public ILo<ImageFile> piclistshortnames = 
    new ConsLo<ImageFile>(this.pic1, 
        new ConsLo<ImageFile>(this.pic2, 
            new ConsLo<ImageFile>(this.pic6, this.mt))); 

  // picture list - small size (< 40000)
  public ILo<ImageFile> piclistsmall = 
    new ConsLo<ImageFile>(this.pic5, 
        new ConsLo<ImageFile>(this.pic6, this.mt));

  // picture list - small size (< 40000)
  public ILo<ImageFile> piclistsmall2 = 
    new ConsLo<ImageFile>(this.pic5, 
        new ConsLo<ImageFile>(this.pic6, this.mt));

  // picture list -- large pictures
  public ILo<ImageFile> piclistlarge = 
    new ConsLo<ImageFile>(this.pic1, 
        new ConsLo<ImageFile>(this.pic2,
            new ConsLo<ImageFile>(this.pic3, this.mt))); 


  // test for the method contains for lists of images
  public boolean testContains(Tester t){
    return 
    t.checkExpect(this.piclistsmall.contains(this.pic3), false, "Contains test 1") &&
    t.checkExpect(this.piclistsmall.contains(this.pic6), true, "Contains test 2");
  }

  // we need an instance of the class SmallImageFile
  public SmallImageFile isSmallImage = new SmallImageFile();

  // test for the method pick for the class SmallImageFile
  public boolean testPickSmallerImageFile(Tester t){
    return 
    t.checkExpect(this.isSmallImage.pick(this.pic5), true) &&
    t.checkExpect(this.isSmallImage.pick(this.pic1), false);
  }

  // we need an instance of the class NameShorterThan4
  public NameShorterThan4 isNameShorterThan4 = new NameShorterThan4();

  // test for the method pick for the class NameShorterThan4
  public boolean testPickNameShorterThan4(Tester t){
    return 
    t.checkExpect(this.isNameShorterThan4.pick(this.pic1), true) &&
    t.checkExpect(this.isNameShorterThan4.pick(this.pic5), false);
  }

  // we need two instances of the class GivenKind
  public ISelect<ImageFile> isGivenKindJpg = new GivenKind("jpg");
  public ISelect<ImageFile> isGivenKindGiff = new GivenKind("giff");

  // test for the method pick for the class GivenKind
  public boolean testPickGivenKind(Tester t){
    return 
    t.checkExpect(this.isGivenKindJpg.pick(this.pic1), true) &&
    t.checkExpect(this.isGivenKindJpg.pick(this.pic2), false) &&
    t.checkExpect(this.isGivenKindGiff.pick(this.pic5), true) &&
    t.checkExpect(this.isGivenKindGiff.pick(this.pic6), false);
  }

  // picture list - all jpg
  public ILo<ImageFile> picalljpg = 
    new ConsLo<ImageFile>(this.pic1, 
        new ConsLo<ImageFile>(this.pic3, 
            new ConsLo<ImageFile>(this.pic6, 
                new ConsLo<ImageFile>(this.pic7, this.mt)))); 

  // picture list - all giff
  public ILo<ImageFile> picallgiff = 
    new ConsLo<ImageFile>(this.pic4, 
        new ConsLo<ImageFile>(this.pic5, this.mt));

  // test for the method filter for lists of images 
  // with the GivenKind predicate
  public boolean testFilterImageFile(Tester t){
    return 
    t.checkExpect(this.piclistall.filter(this.isGivenKindJpg), 
        this.picalljpg) &&
    t.checkExpect(this.piclistall.filter(this.isGivenKindGiff), 
        this.picallgiff);
  }
}