import tester.*;

// examples and tests for lists of books
class ExamplesBooks{
  ExamplesBooks(){}
  
  Book eh1 = new Book("Old Man and the Sea", "EH", 1950);
  Book eh2 = new Book("Snows on Killimanjaro", "EH", 1954);
  Book htdp = new Book("HtDP", "FFFK", 2000);
  Book sn = new Book("Shipping News", "EAP", 2000);
  
  public ImageFile pic1 = new ImageFile("dog", 300, 200, "jpg");
  
  
  ILo<Book> mtlob = new MtLo<Book>();
  ILo<Book> blistEH = new ConsLo<Book>(this.eh1, 
      new ConsLo<Book>(this.eh2, this.mtlob));
  ILo<Book> blist2000 = new ConsLo<Book>(this.htdp, 
      new ConsLo<Book>(this.sn, this.mtlob));
  ILo<Book> blistmix = new ConsLo<Book>(this.eh1, 
      new ConsLo<Book>(this.sn, this.mtlob));

  ILo<Book> blistAll = 
    new ConsLo<Book>(this.eh1,
        new ConsLo<Book>(this.sn,  
            new ConsLo<Book>(this.htdp,
                new ConsLo<Book>(this.eh2, this.mtlob))));
 
  ISelect<Book> bookByEH = new BookByEH();
  ISelect<Book> bookIn2000 = new BookIn2000();
  
  // test the method isSame for the class Book
  boolean testIsSame(Tester t){
    return
    t.checkExpect(this.eh1,
        new Book("Old Man and the Sea", "EH", 1950)) &&
    t.checkFail(this.eh1,
        new Book("Old Man and the", "EH", 1950)) &&
    t.checkFail(this.eh1,
        new Book("Old Man and the Sea", "EXH", 1950)) && 
    t.checkFail(this.eh1,
        new Book("Old Man and the Sea", "EH", 1952)); 
  }
  
  // test the method count for lists of books
  boolean testCount(Tester t){
    return
    t.checkExpect(this.mtlob.count(), 0) &&
    t.checkExpect(this.blistEH.count(), 2) &&
    t.checkExpect(this.blistAll.count(), 4);
  }
  
  // test the method contains for lists of books
  boolean testContains(Tester t){
    return
    t.checkExpect(this.blistEH.contains(this.eh1), true);
  }
  
  // test filter(ISelect select);
  boolean testFilter(Tester t){
    return
    t.checkExpect(this.mtlob.filter(this.bookIn2000), this.mtlob) &&
    t.checkExpect(this.blistmix.filter(this.bookIn2000), 
        new ConsLo<Book>(this.sn, this.mtlob)) &&
    t.checkExpect(this.blistmix.filter(this.bookByEH), 
        new ConsLo<Book>(this.eh1, this.mtlob)) &&
    t.checkExpect(this.blistAll.filter(this.bookByEH), 
        new ConsLo<Book>(this.eh1, 
            new ConsLo<Book>(this.eh2, this.mtlob)));
  }
}