// to represent an empty list of books
public class ConsLo<T> implements ILo<T>{
  T first;
  ILo<T> rest;
  
  ConsLo(T first, ILo<T> rest){
    this.first = first;
    this.rest = rest;
  }
  
/* TEMPLATE:
   FIELDS:
   ... this.first ...    -- T
   ... this.rest ...     -- ILo<T>
   
   METHODS:
   ... this.count() ...                 -- int
   ... this.contains(T) ...             -- boolean
   ... this.filter(ISelectBook<T>) ...  -- ILo<T>
   
   METHODS FOR FIELDS:
   ... this.rest.count() ...                 -- int
   ... this.rest.contains(T) ...             -- boolean
   ... this.rest.filter(ISelectBook<T>) ...  -- ILo<T>
*/
  
  // count the objects in this list
  public int count(){
    return 1 + this.rest.count();
  }
  
  // does this list contain the given object?
  public boolean contains(T t){
    return
    ((IsSame<T>)this.first).isSame(t) ||
    this.rest.contains(t);
  }
  
  // produce a list of all items from this list that satisfy the given predicate
  public ILo<T> filter(ISelect<T> select){
    if (select.pick(this.first))
      return new ConsLo<T>(this.first, 
                           this.rest.filter(select));
    else
      return this.rest.filter(select);
  }
}