import java.util.*;
import tester.*;

/** Examples and tests for the {@link Balloon Balloon} and {@link
 * TopThree TopThree} classes. */
public class Examples{
  
    public Examples(){}
  
    /** A big red {@link Balloon Balloon} */
    Balloon b1 = new Balloon(100, 200, 25, "red");

    /** A small blue {@link Balloon Balloon} */
    Balloon b2 = new Balloon(200, 100, 20, "blue");
  
    /** A big green {@link Balloon Balloon} */
    Balloon b3 = new Balloon(200, 150, 30, "green");
  
    /** A small red {@link Balloon Balloon} */
    Balloon b4 = new Balloon(200, 120, 22, "red");

    /** A method to construct an <code>ArrayList</code> with four
     * {@link Balloon Balloon}s
     * 
     * @return an <code>ArrayList</code> with four {@link Balloon
     * Balloon}s */
    public ArrayList<Balloon> makeArrBlist(){
        ArrayList<Balloon> arrlist = new ArrayList<Balloon>();
        arrlist.add(this.b1);
        arrlist.add(this.b2);
        arrlist.add(this.b3);
        arrlist.add(this.b4);
        return arrlist;
    }
  
    /** {@link Balloon Balloon} class tests: the
     * <code>distanceFromTop</code> method */ 
    public void testDistanceFromTop(Tester t){   
        t.checkExpect(this.b1.distanceFromTop(), 200 - 25, "distanceFromTop 1");    
        t.checkExpect(this.b2.distanceFromTop(), 80, "distanceFromTop 2");  
    }  
}