
// An interface for classes that can compute their value
interface IValue<T>{
    // Compute the value of this instance
    int value();
}

// Represents a list of items of type T
interface ILo<T>{
  
    // Compute the total size (length) of this list
    int size();
   
    // Compute the total value of the items in this list
    int totalValue();
  
    // Does this list contain the given item?
    boolean contains(T t);
}                                

// Represents an empty list of items of type T
class MtLo<T> implements ILo<T>{
    MtLo(){}
  
    // Compute the total size (length) of this empty list
    public int size(){
        return 0;
    }
   
    // Compute the total value of this empty list
    public int totalValue(){
        return 0;
    }
  
    // Does this list of T contain the given T?
    public boolean contains(T t){
        return false;
    }
}                                              

// Represents a nonempty list of items of type T
class ConsLo<T> implements ILo<T>{
    T first;
    ILo<T> rest;
  
    ConsLo(T first, ILo<T> rest){
        this.first = first;
        this.rest = rest;
    }
  
    /* Template:
     *   Fields:
     *     ... this.first ...    -- T
     *     ... this.rest ...     -- ILo<T>
     *
     *   Methods:
     *     ... this.size() ...            -- int
     *     ... this.totalValue() ...      -- int
     *     ... this.contains(T) ...       -- boolean
     *
     *   Methods for Fields:
     *     ... this.rest.size() ...       -- int
     *     ... this.rest.totalValue() ... -- int
     *     ... this.rest.contains(T) ...  -- boolean
     */
  
    // Compute the total size (length) of this nonempty list
    public int size(){
        return 1 + this.rest.size();
    }
   
    // Compute the total value of this nonempty list
    public int totalValue(){
        return ((IValue<T>)this.first).value() + this.rest.totalValue();
    }
  
    // Does this nonempty list of T contain the given T?
    public boolean contains(T t){
        // This is incorrect - we only include it so the program compiles
        return this.rest.contains(t);
    }
}                                                    
