import java.util.*;

/**
 * To represent the map of the US 48 states
 */
class USmap {
  HashMap<String, State> graph;
  
  USmap(){
    graph = new HashMap<String, State>(48);
    initMap();
  }
  
  /**
   * Build the map of the capitals of the 48 US states
   * @return an <code>HashMap</code> of the 48 state names and 
   * the information for each state
   */  
  void initMap(){
    makeStates();
    for (State state: states){
      graph.put(state.name, state);
    }
  }
  
  ArrayList<State> states = new ArrayList<State>();
  
  /**
   * Make a list of the capitals of the 48 US states
   * @return an <code>ArrayList</code> of the 48 states
   */
  public ArrayList<State> makeStates(){
    states.add(new State("AL", 
        new City("36105", "Montgomery", "AL", 86, 32),
        new ArrayList<String>(Arrays.asList("MS", "TN", "GA", "FL"))));
    
    states.add(new State("AZ",
        new City("85009", "Phoenix", "AZ", 112, 33),
        new ArrayList<String>(Arrays.asList("CA", "NV", "UT", "CO", "NM"))));
     
    states.add(new State("AR",
        new City("72201", "Little Rock", "AR", 92, 35),
        new ArrayList<String>(Arrays.asList("LA", "TX", "OK", "MO", "TN", "MS"))));
    
    states.add(new State("CA",
        new City("95819", "Sacramento", "CA", 121, 39),
        new ArrayList<String>(Arrays.asList("AZ", "NV", "OR"))));
    
    states.add(new State("CO",
        new City("80204", "Denver", "CO", 105, 40),
        new ArrayList<String>(Arrays.asList("AZ", "UT", "WY", "NE", "KS", "OK", "NM"))));
    
    states.add(new State("CT",
        new City("06120", "Hartford", "CT", 73, 42),
        new ArrayList<String>(Arrays.asList("NY", "MA", "RI"))));
    
    states.add(new State("DE",
        new City("19901", "Dover", "DE", 76, 40),
        new ArrayList<String>(Arrays.asList("MD", "PA", "NJ"))));
    
    states.add(new State("FL",
        new City("32304", "Tallahassee", "FL", 84, 30),
        new ArrayList<String>(Arrays.asList("AL", "GA"))));
    
    states.add(new State("GA",
        new City("30306", "Atlanta", "GA", 84, 34),
        new ArrayList<String>(Arrays.asList("FL", "AL", "TN", "NC", "SC"))));
    
    states.add(new State("IA",
        new City("50314", "Des Moines", "IA", 94, 41),
        new ArrayList<String>(Arrays.asList("IL", "MO", "NE", "SD", "MN", "WI"))));
    
    states.add(new State("ID",
        new City("83705", "Boise", "ID", 116, 44),
        new ArrayList<String>(Arrays.asList("NV", "OR", "WA", "MT", "WY", "UT"))));
    
    states.add(new State("IL",
        new City("62701", "Springfield", "IL", 90, 40),
        new ArrayList<String>(Arrays.asList("IN", "KY", "MO", "IA", "WI"))));
    
    states.add(new State("IN",
        new City("46219", "Indianapolis", "IN", 86, 40),
        new ArrayList<String>(Arrays.asList("MI", "OH", "KY", "IL"))));
    
    states.add(new State("KS",
        new City("66610", "Topeka", "KS", 96, 39),
        new ArrayList<String>(Arrays.asList("MO", "OK", "CO", "NE"))));
    
    states.add(new State("KY",
        new City("40212", "Frankfort", "KY", 86, 38),
        new ArrayList<String>(Arrays.asList("WV", "VA", "TN", "MO", "IL", "IN", "OH"))));
    
    states.add(new State("LA",
        new City("70815", "Baton Rouge", "LA", 91, 30),
        new ArrayList<String>(Arrays.asList("TX", "OK", "AR", "MS"))));
    
    states.add(new State("MA",
        new City("02115", "Boston", "MA", 71, 42),
        new ArrayList<String>(Arrays.asList("NY", "VT", "NH", "RI", "CT"))));
    
    states.add(new State("MD",
        new City("21403", "Annapolis", "MD", 76, 39),
        new ArrayList<String>(Arrays.asList("DE", "PA", "VA"))));
    
    states.add(new State("ME",
        new City("04330", "Augusta", "ME", 70, 44),
        new ArrayList<String>(Arrays.asList("NH"))));
    
      states.add(new State("MI",
        new City("48823", "Lansing", "MI", 84, 43),
        new ArrayList<String>(Arrays.asList("OH", "IN"))));
    
    states.add(new State("MN",
        new City("55103", "Saint Paul", "MN", 93, 45),
        new ArrayList<String>(Arrays.asList("WI", "IA", "SD", "ND"))));
    
    states.add(new State("MO",
        new City("65101", "Jefferson City", "MO", 92, 39),
        new ArrayList<String>(Arrays.asList("IL", "KY", "TN", "AR", "OK", "KS", "NE", "IA"))));
    
    states.add(new State("MS",
        new City("39209", "Jackson", "MS", 90, 32),
        new ArrayList<String>(Arrays.asList("AL", "LA", "AR", "TN"))));
    
    states.add(new State("MT",
        new City("59635", "Helena", "MT", 112, 47),
        new ArrayList<String>(Arrays.asList("ND", "SD", "WY", "ID"))));
    
    states.add(new State("NC",
        new City("27606", "Raleigh", "NC", 79, 36),
        new ArrayList<String>(Arrays.asList("VA", "TN", "GA", "SC"))));
    
    states.add(new State("ND",
        new City("58501", "Bismarck", "ND", 101, 47),
        new ArrayList<String>(Arrays.asList("MN", "SD", "MT"))));
    
    states.add(new State("NE",
        new City("68503", "Lincoln", "NE", 97, 41),
        new ArrayList<String>(Arrays.asList("IA", "MO", "KS", "CO", "WY", "SD"))));
    
    states.add(new State("NH",
        new City("03301", "Concord", "NH", 72, 43),
        new ArrayList<String>(Arrays.asList("ME", "MA", "VT"))));
    
    states.add(new State("NJ",
        new City("08618", "Trenton", "NJ", 75, 40),
        new ArrayList<String>(Arrays.asList("DE", "PA", "NY"))));
    
    states.add(new State("NM",
        new City("87505", "Santa Fe", "NM", 106, 36),
        new ArrayList<String>(Arrays.asList("AZ", "UT", "CO", "OK", "TX"))));
    
    states.add(new State("NV",
        new City("89704", "Carson City", "NV", 120, 39),
        new ArrayList<String>(Arrays.asList("CA", "OR", "ID", "UT", "AZ"))));
    
    states.add(new State("NY",
        new City("12207", "Albany", "NY", 74, 43),
        new ArrayList<String>(Arrays.asList("VT", "MA", "CT", "NJ", "PA"))));
    
    states.add(new State("OH",
        new City("43210", "Columbus", "OH", 83, 40),
        new ArrayList<String>(Arrays.asList("PA", "WV", "KY", "IN", "MI"))));
    
    states.add(new State("OK",
        new City("73105", "Oklahoma City", "OK", 98, 36),
        new ArrayList<String>(Arrays.asList("AR", "TX", "NM", "CO", "KS", "MO"))));
    
    states.add(new State("OR",
        new City("97301", "Salem", "OR", 123, 45),
        new ArrayList<String>(Arrays.asList("WA", "ID", "NV", "CA"))));
    
    states.add(new State("PA",
        new City("17101", "Harrisburg", "PA", 77, 40),
        new ArrayList<String>(Arrays.asList("NY", "NJ", "DE", "MD", "VA", "WV", "OH"))));
    
    states.add(new State("RI",
        new City("02908", "Providence", "RI", 71, 41),
        new ArrayList<String>(Arrays.asList("MA", "CT"))));
    
    states.add(new State("SC",
        new City("29209", "Columbia", "SC", 81, 34),
        new ArrayList<String>(Arrays.asList("NC", "GA"))));
    
    states.add(new State("SD",
        new City("57501", "Pierre", "SD", 100, 44),
        new ArrayList<String>(Arrays.asList("MN", "IA", "NE", "WY", "MT", "ND"))));
    
    states.add(new State("TN",
        new City("37914", "Nashville", "TN", 84, 36),
        new ArrayList<String>(Arrays.asList("NC", "GA", "AL", "MS", "AR", "MO", "KY"))));
    
    states.add(new State("TX",
        new City("78721", "Austin", "TX", 98, 30),
        new ArrayList<String>(Arrays.asList("NM", "OK", "AR", "LA"))));
    
    states.add(new State("UT",
        new City("84103", "Salt Lake City", "UT", 112, 41),
        new ArrayList<String>(Arrays.asList("CO", "NM", "AZ", "NV", "ID", "WY"))));
    
    states.add(new State("VA",
        new City("23222", "Richmond", "VA", 77, 38),
        new ArrayList<String>(Arrays.asList("MD", "PA", "WV", "KY", "TN", "NC"))));
    
    states.add(new State("VT",
        new City("05602", "Montpelier", "VT", 73, 44),
        new ArrayList<String>(Arrays.asList("NY", "NH", "MA"))));
    
    states.add(new State("WA",
        new City("98501", "Olympia", "WA", 123, 47),
        new ArrayList<String>(Arrays.asList("ID", "OR"))));
    
    states.add(new State("WI",
        new City("53714", "Madison", "WI", 89, 43),
        new ArrayList<String>(Arrays.asList("IL", "IA", "MN"))));
    
    states.add(new State("WV",
        new City("25301", "Charleston", "WV", 82, 38),
        new ArrayList<String>(Arrays.asList("PA", "VA", "KY", "OH"))));
    
    states.add(new State("WY",
        new City("82001", "Cheyenne", "WY", 105, 41),
        new ArrayList<String>(Arrays.asList("SD", "NE", "CO", "UT", "ID", "MT"))));

    return states;
  }
 
  /**
   * Compute the distance from the state represented by the
   * given <code>String</code> to another state represented
   * by the given <code>String</code>
   * @param goingFrom the origin state
   * @param goingTo the destination state
   * @return the distance between the capitals of the two states
   */
  double computeDistance(String goingFrom, String goingTo){
    State state1 = graph.get(goingFrom);
    State state2 = graph.get(goingTo);
    if (state1.neighbors.contains(state2.name))
      return state1.city.distanceTo(state2.city);
    else
      throw new IllegalArgumentException(
          "States " + state1.name + " and " + state2.name +
          " are not neighbors.");
  }
  
  /** 
   * Produce a <code>String</code> that represents this 
   * US map
   * 
   * @return the desired string
   */
  public String toString(){
    Collection<State> data = this.graph.values();
    String s = "";
    for (State state : data){
      s = s + state.toString() + "\n";
    }
    return s;
  }
}

