import java.util.*;

/**
 * To represent a state in the US map
 */
class State{
  String name;
  City city;
  ArrayList<String> neighbors;
  
  /**
   * The standard full constructor
   * @param name the name of this state
   * @param city the capitol city of this state
   * @param neighbors the list of neighboring states
   */
  State(String name, City city, ArrayList<String> neighbors){
    this.name = name;
    this.city = city;
    this.neighbors = neighbors;
  }
  
  /** 
   * Produce a <code>String</code> that represents 
   * this state
   * 
   * @return the desired string
   */
  public String toString(){
    return this.city.toString() + "\n" +
           "neighbors: " + toStringNeighbors();
  }
  
  /** 
   * Produce a <code>String</code> that represents 
   * this neighbors of this state
   * 
   * @return the desired string
   */
  protected String toStringNeighbors(){
    String s = "";
    for (String n : this.neighbors){
      s = s + n + " ";
    }
    return s;
  }
}