import java.util.ArrayList;
import java.util.Arrays;
import world.*;
import image.*;

import tester.*;

/**
 * Examples for the problem that deals with the US map
 */
class ExamplesGraphAlgorithms{
  USmap us = new USmap();
  
  /** sample cities */
  City hartford = new City("06120", "Hartford", "CT", 73, 42);
  City boston = new City("02115", "Boston", "MA", 71, 42);
  City concord = new City("03301", "Concord", "NH", 72, 43);
  
  /** the 48 states */
  State nh = 
    new State("NH",
        new City("03301", "Concord", "NH", 72, 43),
        new ArrayList<String>(Arrays.asList("ME", "MA", "VT")));
  State ma = 
    new State("MA",
      new City("02115", "Boston", "MA", 71, 42),
      new ArrayList<String>(Arrays.asList("NY", "VT", "NH", "RI", "CT")));
  
  State ct = 
    new State("CT",
      new City("06120", "Hartford", "CT", 73, 42),
      new ArrayList<String>(Arrays.asList("NY", "MA", "RI")));
  
  /**
   * Tests for all methods in the classes City, State, and USmap
   * @param t the tester that runs the tests
   */
  void testUSmap(Tester t){
    t.checkExpect(us.graph.size(), 48);
    
    t.checkInexact(this.hartford.distanceTo(this.boston), 140.0, 0.1);
    t.checkInexact(this.concord.distanceTo(this.boston), 90.0, 0.1);
    
    t.checkExpect(this.hartford.toPosn(), new Posn(347, 107));
    t.checkExpect(this.boston.toPosn(), new Posn(360, 107));
    t.checkExpect(this.concord.toPosn(), new Posn(354, 94));
    
    t.checkExpect(this.ct.neighbors.contains("MA"), true);
    t.checkExpect(this.ct.neighbors.contains("NY"), true);
    t.checkExpect(this.ct.neighbors.contains("RI"), true);
    

    t.checkInexact(this.us.computeDistance("CT", "MA"), 140.0, 0.1);
    t.checkInexact(this.us.computeDistance("NH", "MA"), 90.0, 0.1);
  }
}