/*
                   ............................................................
                   v                                                          :
     +-------------------------+                                              :
     | Traversal<T>            |                                              :
     +-------------------------+                                              :
     | boolean      isEmpty()  |                                              :
     | T            getFirst() |                                              :
     | Traversal<T> getRest()  |                                              :
     +-------------------------+                                              :
          / \            / \                                                  :
          ---            ---                                                  :
           |              |                                                   :
      +------------+      +------------------+                                :
      | IList<T>   |<-+                      |                                :
      +------------+  |            +----------------------------------------+ :
          / \         |            | ArrLT<T>                               | :
          ---         +----------+ +----------------------------------------+ :
           |                     | | ArrayList<T> arrlist                   | :
    ------------------           | | int          first                     | :
    |                |           | +----------------------------------------+ :
+-----------+ +----------------+ | | public ArrLT<T>(ArrayList<T> arrlist)  | :
| MTList<T> | | ConsList<T>    | | | private ArrLT<T>(ArrayList<T> arrlist, | :
+-----------+ +----------------+ | |                  int first)            | :
              | T        first | | +----------------------------------------+ :
              | IList<T> rest  |-+                                            :
              +----------------+                                              :
                                                                              :
                       +----------------------------------------------------+ :
                       | Algorithms                                         | :
                       +----------------------------------------------------+ :
               ........| boolean contains(Traversal<T> tr, ISelect<T> pick) |.:
               :   ....| int    countSuch(Traversal<T> tr, ISelect<T> pick) |.:
               :   :   +----------------------------------------------------+
               v   v
           +-----------------------------+
           | ISelect<T>                  |
           +-----------------------------+
           | boolean select(T t)         |   
           +-----------------------------+
            / \                       / \
            ---                       ---
             |                         |
+---------------------------+  +---------------------------+
| <Balloon>                 |  | <Balloon>                 |
| RedBalloon                |  | SmallBalloon              |
+---------------------------+  +---------------------------+
| boolean select(Balloon b) |  | boolean select(Balloon b) |
+---------------------------+  +---------------------------+

    
 
+---------------------------------------------------+
| Examples                                          |
+---------------------------------------------------+
| Traversal<Balloon> blist: ConsList<Balloon>       |
| Traversal<Balloon> arrblist: ArrLT<Balloon>       |
|...................................................|
| ISelect<Balloon> redBalloon: RedBalloon           |
| ISelect<Balloon> smallBalloon: SmallBalloon       |
....................................................|
| Algorithms algo: Algorithms                       |
|...................................................|
| algo.contains(blist, redBalloon) -> boolean       |
| algo.contains(blist, smallBalloon) -> boolean     |
| algo.contains(arrblist, redBalloon) -> boolean    |
| algo.contains(arrblist, smallBalloon) -> boolean  |
|...................................................|
| algo.countSuch(blist, redBalloon) -> boolean      |
| algo.countSuch(blist, smallBalloon) -> boolean    |
| algo.countSuch(arrblist, redBalloon) -> boolean   |
| algo.countSuch(arrblist, smallBalloon) -> boolean |
+---------------------------------------------------+
*/
