import tester.*;  

// Test the use of function objects with lists of ImageFile-s
public class ExamplesImageFile{
  public ExamplesImageFile(){}

  // sample data to be used for all tests
  public ImageFile pic1 = new ImageFile("dog", 300, 200, "jpg");
  public ImageFile pic2 = new ImageFile("cat", 200, 200, "png");
  public ImageFile pic3 = new ImageFile("bird", 250, 200, "jpg");
  public ImageFile pic4 = new ImageFile("horse", 300, 300, "giff");
  public ImageFile pic5 = new ImageFile("goat", 100, 200, "giff");
  public ImageFile pic6 = new ImageFile("cow", 150, 200, "jpg");
  public ImageFile pic7 = new ImageFile("snake", 200, 300, "jpg");

  //empty list
  public IListImageFile mt= new MTListImageFile();

  // picture list -- all pictures
  public IListImageFile piclistall = 
    new ConsListImageFile(this.pic1, 
        new ConsListImageFile(this.pic2,
            new ConsListImageFile(this.pic3, 
                new ConsListImageFile(this.pic4, 
                    new ConsListImageFile(this.pic5, 
                        new ConsListImageFile(this.pic6, 
                            new ConsListImageFile(this.pic7, this.mt))))))); 

  // picture list - short names (less than 4 characters)
  public IListImageFile piclistshortnames = 
    new ConsListImageFile(this.pic1, 
        new ConsListImageFile(this.pic2, 
            new ConsListImageFile(this.pic6, this.mt))); 

  // picture list - small size (< 40000)
  public IListImageFile piclistsmall = 
    new ConsListImageFile(this.pic5, 
        new ConsListImageFile(this.pic6, this.mt));

  // picture list - small size (< 40000)
  public IListImageFile piclistsmall2 = 
    new ConsListImageFile(this.pic5, 
        new ConsListImageFile(this.pic6, this.mt));

  // picture list -- large pictures
  public IListImageFile piclistlarge = 
    new ConsListImageFile(this.pic1, 
        new ConsListImageFile(this.pic2,
            new ConsListImageFile(this.pic3, this.mt))); 


  // a sample test
  public boolean testContains(Tester t){
    return 
    t.checkExpect(this.piclistsmall.contains(this.pic3), false, "Contains test 1") &&
    t.checkExpect(this.piclistsmall.contains(this.pic6), true, "Contains test 2");
  }

}