
// Represents a node in a linked list of Strings
public class Node{
    String data;
    Node next;
  
    public Node(String data, Node next){
        this.data = data;
        this.next = next;
    }

    /* Template:
     *   Fields:
     *     ... this.data ...  -- String
     *     ... this.next ...  -- Node
     *
     *   Methods:
     *     ... this.lastNode() ...        -- void
     *     ... this.insertAfter(Node) ... -- void
     *
     *   Methods for Fields:
     *     ... this.next.lastNode() ...        -- void
     *     ... this.next.insertAfter(Node) ... -- void
     */
  
    // Is this the sentinel node? No
    boolean lastNode(){
        return false;
    }
  
    // EFFECT: Insert the given String into this linked list in sorted
    //           order, where the given node is the node in the list
    //           before this one
    void insertAfter(Node prev, String string){
        if(string.compareTo(this.data) <= 0){
            prev.next = new Node(string, this);
        }else{
            this.next.insertAfter(this, string);
        }
    }
}

// Represents the last Node in a linked list of Strings
class Sentinel extends Node{

    // Only we can construct a new Sentinel Node
    private Sentinel(){
        super("", null);
    }
  
    // The one and only instance of Sentinel
    // This is a use of the "Singleton Pattern"
    public static Sentinel tail = new Sentinel();
  

    // Is this the sentinel node? Yes
    boolean lastNode(){
        return true;
    }  
  
    // EFFECT: Insert the given String into this linked list in sorted
    //           order, where the given Node is the node in the list
    //           before this one
    void insertAfter(Node prev, String string){
        Node tmp = new Node(string, this);
        prev.next = tmp;
    } 
}
