import tester.*;

//Used with the tester.
public class ExamplesAccounts {
  
	//Checking template
	// accountNum ... int
	// balance    ... int
	// name       ... String
	// minimum    ... int
	
	Account check1; 
	Account check2;
	Account check3;
	
	//Savings Template
	// accountNum ... int
	// balance    ... int
	// name       ... String
	// interest   ... double
	Account savings1;
	Account savings2;
	Account savings3;
	
	
	//Empty constructor.
	public ExamplesAccounts(){ }
	
	//Initializes some accounts to use for testing.
	//We place inside init() so we can "reuse" the accounts
	public void reset(){
		
		//Initialize the checking accounts.
		check1 = new Checking(0001, 0, "First Checking Account", 0);
		check2 = new Checking(0002, 100, "Second Checking Account", 50);
		check3 = new Checking(0003, 500, "Third Checking Account", 0);
		
		//Initialize the savings accounts.
		savings1 = new Savings(0004, 0, "First Savings Account", 4.9);
		savings2 = new Savings(0005, 100, "Second Savings Account", 8.9);
		savings3 = new Savings(0006, 0, "Third Savings Account", 1.1);
	}
	
	//Tests the exceptions we expect to be thrown when
	//performing an "illegal" action.
	public void testExceptions(Tester t){
		reset();
		Object[] args = new Object[1];
		args[0] = 100;
		t.checkException(
				"The test should pass, we supplied the right information",
				new RuntimeException("Insufficient Funds for " + check1.name + " Account."),
				check1,
				"withdraw",
				args
				);
		t.checkException(
				"The test should pass, we supplied the right information",
				new RuntimeException("Insufficient Funds for " + savings1.name + " Account."),
				savings1,
				"withdraw",
				args
				);
		
	}
	
	//Tests the deposit methods inside certain accounts.
	public void testDeposit(Tester t){
		reset();
		t.checkExpect(check1.deposit(100), 100);
		t.checkExpect(check1, new Checking(0001, 100, "First Checking Account", 0));
		reset();
	}
	
	
}
