// Checking accounts
// (c) 2010 Viera K. Proulx

// to represent a checking account in a bank
public class Checking extends Account{

  public int minimum;  // The minimum amount a customer is allowed to have
	              // in their account at any particular point in time.

  // the constructor
  public Checking(int accountNum, int balance, String name, int minimum){
		super(accountNum, balance, name);
		this.minimum = minimum;
	}

  /* TEMPLATE
     FIELDS:
     ... this.accountNum ...      -- int
     ... this.balance ...         -- int
     ... this.name ...            -- String
     ... this.minimum ...         -- int

     METHODS: 
     ... this.withdraw(int) ...   -- void 

     METHODS FOR FIELDS:      

   */

	// produce the new balance after withdrawal 
	// of the given amount from this account
	public int withdraw(int amount){
		if (this.balance - amount < this.minimum) {
			throw new RuntimeException("Insufficient Funds for " + this.name + " Account.");
		} else {
			return this.balance = this.balance - amount;
		}
	}	

}
