import java.util.*;
import java.awt.image.*;
import java.awt.image.BufferedImage;
import java.io.*;
import javax.imageio.ImageIO;
import java.awt.Color;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;

/**
 * 
 * @author Viera K. Proulx
 * @since 4 April 2010
 *
 * This class reads the Mars image files 
 * generated by the Viking Explorer and provided by NASA.
 * The program that wishes to use that data can read the labels 
 * from the <code>String labels</code> field and get the image byte data
 * from the <code>BufferedInputStream bytestream</code>
 */
public class MarsFileReader{
  
  /** the input reader for reading the text labels */
  protected BufferedReader buffer;
  
  /** the byte input reader for reading the pixel shade data */
  protected BufferedInputStream bytestream;
  
  /** the file reader - used first to read lines, then bytes */
  FileInputStream filestream;
  
  /** the file that holds the original images */
  File marsfile;
  
  /** one line of input at a time */
  protected String line;
  
  /** the labels read from the Mars file */
  protected String labels;
  
  /** the buffer that saves the user-generated image */
  BufferedImage image = new BufferedImage(320, 306, 
      BufferedImage.TYPE_INT_ARGB);
  
  /** a flag to see if the input file is available */
  boolean closed = true;
  
  public MarsFileReader() {

    /** build a file chooser 
     and have the user choose a file, 
     quitting this operation 
     if the user canceled the choice */
    JFileChooser chooser = new JFileChooser(".");
    
    /** set the file extension to be .bmp or .png */
    chooser.setFileFilter(new ImageFileFilter());
    
    this.closed = false;
    
    /** see if file was selected - quit if user canceled */
    if (chooser.showOpenDialog(null) != JFileChooser.APPROVE_OPTION){
      this.closed = true;
      return;
    }
    
    /** now we can set up the buffer to read labels */
    try{
      this.marsfile = chooser.getSelectedFile();
      this.buffer = new BufferedReader(new FileReader(this.marsfile));
    }
    catch(FileNotFoundException e){
      System.out.println("File not found exception: " + e);
      this.closed = true;        
    }
    
    /** reading the labels and the histogram data */
    int count = 0;
    while(!this.closed && count < 73){
    /** read one line of input from the selected file 
     *  and extract values for the first city */
      getnext();
      count ++;
    }
    System.out.println(this.labels);
    
    /** now we set up the FileInputStream for the user to process */
    try{
      this.filestream = new FileInputStream(this.marsfile);
      this.bytestream = new BufferedInputStream(this.filestream);
      
      //... now we jump ahead the number of bytes seen 
      // so we can read the colors
      this.bytestream.skip(3672);
    }
    catch(FileNotFoundException e){
      System.out.println("File not found exception: " + e);
      this.closed = true;        
    }
    catch(IOException e){
      System.out.println("Error when reading bytes: " + e);
      this.closed = true;        
    }
  }

  /** 
   * Process next item, if available 
   */
  private void getnext() {
    
    if (!this.closed)
      try{
        if (this.buffer.ready()){
          
          this.line = new String(this.buffer.readLine());
          if ((this.line == null)){     
            this.buffer.close();
            this.closed = true;
          }
          else{ 
            this.labels = this.labels + this.line + "\n";
            //System.out.println(this.line);
          }            
        }
        else{
          this.buffer.close();
          this.closed = true;
        }
      }
    catch(Exception e) {
      System.out.println("Error in reading line exception: " + e);
      this.closed = true;
    }
    
  }
 
  public static void main(String[] argv){
    System.out.println("ready to read");
    MarsFileReader mfr = new MarsFileReader();
    System.out.println("done reading");
  } 
}

/**
 * Class used to assure that only file names with the suffix .bmp
 * and .png are seen in the FileChooser dialog.
 * 
 * @author Viera K. Proulx
 * @since 4 April 2010
 *
 */
class ImageFileFilter extends FileFilter{

  public boolean accept(File f){
    // accept if file name has no suffix
    return !f.getName().contains(".") ;
  }

  public String getDescription(){
    return "Bit map, png files, and files with no suffix";
  }
}
