import tester.*;  

// Test the use of function objects with lists of ImageFile-s
public class Examples{
    
    // sample data to be used for all tests
    public ImageFile pic1 = new ImageFile("dog", 300, 200, "jpg");
    public ImageFile pic2 = new ImageFile("cat", 200, 200, "png");
    public ImageFile pic3 = new ImageFile("bird", 250, 200, "jpg");
    public ImageFile pic4 = new ImageFile("horse", 300, 300, "giff");
    public ImageFile pic5 = new ImageFile("goat", 100, 200, "giff");
    public ImageFile pic6 = new ImageFile("cow", 150, 200, "jpg");
    public ImageFile pic7 = new ImageFile("snake", 200, 300, "jpg");
    
    //empty list
    AList mt= new MTList();

    // picture list -- all pictures
    AList piclistall = new ConsList(pic1, 
        new ConsList(pic2,
            new ConsList(pic3, 
                new ConsList(pic4, 
                    new ConsList(pic5, 
                        new ConsList(pic6, 
                            new ConsList(pic7, mt))))))); 
      
  // picture list - short names (less than 4 characters)
  AList piclistshortnames = new ConsList(pic1, 
      new ConsList(pic2, 
          new ConsList(pic6, mt))); 
  
  // picture list - small size (< 40000)
  AList piclistsmall = new ConsList(pic5, 
      new ConsList(pic6, mt));
  
  // picture list - small size (< 40000)
  AList piclistsmall2 = new ConsList(pic5, 
      new ConsList(pic6, mt));

  // picture list -- large pictures
  AList piclistlarge = new ConsList(pic1, 
      new ConsList(pic2,
          new ConsList(pic3,mt))); 

     
    // a sample test
    public boolean testContains(Tester t){
      return 
      t.checkExpect(this.piclistsmall.contains(this.pic3), false, "Contains test 1") &&
      t.checkExpect(this.piclistsmall.contains(this.pic6), true, "Contains test 2");
    }
 
  
  }