package game;

import idraw.*;
import colors.*;
import geometry.*;

/**
 * A class to represent a world with a <code>Rat</code> 
 * and <code>Food</code>. The <code>Food</code> grows on each tick,
 * the <code>Rat</code> moves with the arrow keys and to the position
 * where the mouse was clicked. The <code>World</code> ends when the 
 * food grow to be too big.
 * 
 * <p>A class to represent a game used to test the world teachpack 
 * (packages 
 * <code>{@link draw draw}</code>,
 * <code>{@link geometry geometry}</code>,
 * <code>{@link colors colors}</code>).</p>
 * 
 * <p>The world consists of a <code>{@link Rat Rat}</code> and 
 * <code>{@link Food Food}</code>. The <code>{@link Food Food}</code> 
 * grows on each tick, the <code>{@link Rat Rat}</code> moves 
 * with the arrow keys (or l, r, u, d keys) as well as to the position
 * where the mouse was clicked. The <code>{@link World World}</code> 
 * ends when the food grow to be too big.
 * 
 * @author Viera K. Proulx
 * @since November 5, 2009
 */
class RatWorld extends World{
  Rat r;
  Food glob;

  RatWorld(Rat r, Food glob){
    this.r = r;
    this.glob = glob;
  }

  /**
   * Create the world (of size 200 by 200) and start the timer
   * 
   * @param speed the rate at which the clock should tick
   */
  void go(double speed) { 
    this.bigBang(200, 200, speed); 
  }
 
  /**
   * On tick - grow the food, stop the <code>{@link World World}</code> 
   * if there is too much food (size > 25)
   */
  public void onTick() { 
    if (this.glob.size > 25) {
      this.endOfWorld("Too much food.");
    }
    else {
      this.glob.grow(); 
    }
  }

  /**
   * If key event is one of the arrow keys or one of the letters
   * l, r, u, d -- move the rat in the given direction.
   * 
   * @return the new <code>{@link World World}</code> with 
   * <code>{@link Rat Rat}</code> moved as desired
   */  
  public void onKeyEvent(String ke){
    if (ke.equals("left") || ke.equals("l")) {            // rat moves left
      this.r.move(-3, 0);
    }
    else if (ke.equals("right") || ke.equals("r")) {      // rat moves right
      this.r.move(3, 0);
    }
    else if (ke.equals("up") || ke.equals("u")) {         // rat moves up
      this.r.move(0, -3);
    }
    else if (ke.equals("down") || ke.equals("d")) {       // rat moves down
      this.r.move(0, 3);
    }
                                                          // rat does not move
  }
  
  /**
   * Move the rat to the mouse position given by the mouse click
   * 
   * @param p the position given by the mouse click
   * @return the new <code>{@link World World}</code> with 
   * <code>{@link Rat Rat}</code> moved as desired
   */
  public void onMouseClick(Posn p){
    this.r.moveTo(p);
  }

  /**
   * Draw the scene: the <code>{@link Rat Rat}</code> 
   * and the <code>{@link Food Food}</code> on 
   * <code>theCanvas</code>
   */
  public void draw(){
    this.r.draw(this.theCanvas);
    this.glob.draw(this.theCanvas);
  }

}
