package game;
import idraw.*;
import colors.*;
import geometry.*;

/**
 * A rat in a simple version of an interactive game 
 * - used to test the world teachpack (packages 
 * <code>{@link draw draw}</code>,
 * <code>{@link geometry geometry}</code>,
 * <code>{@link colors colors}</code>).
 * 
 * @author Viera K. Proulx
 * @since August 2, 2007
 */

/**
 * To represent a rat in a rat race
 */
class Rat {
  String name;
  Posn loc;
  int size;

  Rat(String name, Posn loc, int size) {
    this.name = name;
    this.loc = loc;
    this.size = size;
  }

  /**
   * EFFECT: Move this <code>{@link Rat Rat}</code> by the given distance
   * 
   * @param dx the horizontal displacement
   * @param dy the vertical displacement
   */ 
  void move(int dx, int dy){
    this.loc.x = this.loc.x + dx; 
    this.loc.y = this.loc.y + dy;
  }

  /**
   * EFFECT: Move this <code>{@link Rat Rat}</code> to the given position
   * 
   * @param pos the position where to move the rat
   */   
  void moveTo(Posn pos){
    this.loc = pos;
  }

  /**
   * Effect: Draw this <code>{@link Rat Rat}</code> on the given canvas
   * 
   * @param c the given <code>{@link Canvas Canvas}</code>
   * @return <code>true</code>
   */   
  void draw(Canvas c){
    if (this.size == 0)
      // draw a dead rat in black
      c.drawDisk(this.loc, 3, new Black());
    else
      // draw a live rat in blue - and at the appropriate size
      c.drawDisk(this.loc, this.size, new Blue());
  }
}