package game;

import geometry.*;
import colors.*;
import idraw.*;

/**
 * A simple self-contained example of running two worlds concurrently
 * at a different speed. The world consists of one red disk. The radius
 * changes by <code>dx</code> on each tick. Arrow keys and the keys 
 * l, r, u, d move the disk. The world ends when the disk radius 
 * reaches (or exceeds) 100.
 * 
 * @author Viera K. Prooulx
 * @since November 5, 2009
 */
public class GameWorld extends World{
  
  /** the x-coordinate of the center */
  public int x;

  /** the y-coordinate of the center */
  public int y;

  /** the radius of the disk */
  public int radius;

  /** the change in radius on each tick */
  public int dr;
    
  /**
   * Construct the world
   * 
   * @param x the x-coordinate of the center
   * @param y the y-coordinate of the center
   * @param radius the radius of the disk
   * @param dr the change in radius on each tick
   */
  public GameWorld(int x, int y, int radius, int dr){
    super();
    this.x = x;
    this.y = y;
    this.radius = radius;
    this.dr = dr;
  }

  /**
   * <p>If key event is one of the arrow keys or one of the letters
   * l, r, u, d -- move the disk in the given direction.</p>
   * <p>Stop the world if the user presses 's'.</p>
   * 
   * @return the new <code>{@link World World}</code> with disk moved 
   * as desired
   */  public void onKeyEvent(String ke) {
    if (ke.equals("u") || ke.equals("up")){
      this.y = this.y - 3;
    }
    
    else if (ke.equals("d") || ke.equals("down")){
      this.y = this.y + 3;
    }
    
    else if (ke.equals("l") || ke.equals("left")){
      this.x = this.x - 3;
    }
    
    else if (ke.equals("r") || ke.equals("right")){
      this.x = this.x + 3;
    }
    
    else if (ke.equals("s")){
      this.endOfTime("The world stopped -- dx = " + dr);
    }
  }

   /**
    * <p>On tick - change the disk radius by <code>dr</code></p>
    * 
    * <p>The <code>{@link World World}</code> now has
    * more <code>{@link Food Food}</code></p>
    */
  public void onTick() {
    System.out.println("tick " + this.dr);
    
    // if the disk is too big, stop
    if (this.radius >= 100){
       this.endOfWorld("THE END - dr = " + this.dr);
    }

    // else grow the disk
    else
      this.radius = this.radius + dr;
  }
  
  /**
   * Draw the scene: a red disk. 
   */
  public void draw() {
    this.theCanvas.drawDisk(new Posn(this.x, this.y), this.radius, new Red());
  }

  
  /**
   * The observational self-test: displays two worlds growing 
   * at different rates -- displays each tick processed.
   * 
   * @param argv
   */
  public static void main(String argv[]){
    System.out.println("Self test for the GameWorldX");
   
    // start the first world
    GameWorld gw = new GameWorld(50, 200, 10, 10);
    gw.bigBang(200, 400, 2.0);
    
    // start the second world - twice as fast as the first one
    GameWorld gw2 = new GameWorld(100, 300, 10, 15);
    gw2.bigBang(200, 400, 1.0);
  }
}