package game;
import idraw.*;
import colors.*;
import geometry.*;

/**
 * A food in a simple version of an interactive game 
 * - used to test the world teachpack (packages 
 * <code>{@link draw draw}</code>,
 * <code>{@link geometry geometry}</code>,
 * <code>{@link colors colors}</code>).
 * 
 * @author Viera K. Proulx
 * @since August 2, 2007
 */

/**
 * To represent a glob of food in a rat game.
 */
class Food{
  Posn loc;
  int size;

  Food(Posn loc, int size) {
    this.loc = loc;
    this.size = size;
  }

  /**
   * EFFECT: Grow this food as time goes on
   */
  void grow(){
    this.size = this.size + 1;
  }

  /**
   * EFFECT: Draw this <code>{@link Food Food}</code> on the given canvas
   * 
   * @param c the given <code>{@link Canvas Canvas}</code>
   */   
  void draw(Canvas c){
    c.drawDisk(this.loc, size, new Red());
  }
}
