package game;
import draw.*;
import colors.*;
import geometry.*;

/**
 * A rat in a simple version of an interactive game 
 * - used to test the world teachpack (packages 
 * <code>{@link draw draw}</code>,
 * <code>{@link geometry geometry}</code>,
 * <code>{@link colors colors}</code>).
 * 
 * @author Viera K. Proulx
 * @since August 2, 2007
 */

/**
 * To represent a rat in a rat race
 */
class Rat {
  String name;
  Posn loc;
  int size;

  Rat(String name, Posn loc, int size) {
    this.name = name;
    this.loc = loc;
    this.size = size;
  }

  /**
   * Move this <code>{@link Rat Rat}</code> by the given distance
   * 
   * @param dx the horizontal displacement
   * @param dy the vertical displacement
   * @return the rat in a new postition
   */ 
  Rat move(int dx, int dy){
    return new Rat(this.name, 
                   new Posn(this.loc.x + dx, 
                            this.loc.y + dy),
                   this.size);
  }

  /**
   * Move this <code>{@link Rat Rat}</code> to the given position
   * 
   * @param pos the position where to move the rat
   * @return the rat in a new postition
   */   
  Rat moveTo(Posn pos){
    return new Rat(this.name, pos, this.size);
  }

  /**
   * Draw this <code>{@link Rat Rat}</code> on the given canvas
   * 
   * @param c the given <code>{@link Canvas Canvas}</code>
   * @return <code>true</code>
   */   
  boolean draw(Canvas c){
    if (this.size == 0)
      // draw a dead rat in black
      return c.drawDisk(this.loc, 3, new Black());
    else
      // draw a live rat in blue - and at the appropriate size
      return c.drawDisk(this.loc, this.size, new Blue());
  }
}