package game;
import draw.*;
import colors.*;
import geometry.*;

/**
 * A food in a simple version of an interactive game 
 * - used to test the world teachpack (packages 
 * <code>{@link draw draw}</code>,
 * <code>{@link geometry geometry}</code>,
 * <code>{@link colors colors}</code>).
 * 
 * @author Viera K. Proulx
 * @since August 2, 2007
 */

/**
 * To represent a glob of food in a rat game.
 */
class Food{
  Posn loc;
  int size;

  Food(Posn loc, int size) {
    this.loc = loc;
    this.size = size;
  }

  /**
   * Grow this food as time goes on
   */
  Food grow(){
    return new Food(this.loc, this.size + 1);
  }

  /**
   * Draw this <code>{@link Food Food}</code> on the given canvas
   * 
   * @param c the given <code>{@link Canvas Canvas}</code>
   * @return <code>true</code>
   */   
  boolean draw(Canvas c){
    return c.drawDisk(this.loc, size, new Red());
  }
}
