package game;

import java.io.IOException;

import draw.*;
import colors.*;
import geometry.*;

/**
 * A class to illustrate the behavior of a standalone 
 * <code>{@link Canvas Canvas}</code>
 * and the <code>{@link World World}</code> interactions.
 *
 * @author Viera K. Proulx
 * @since August2, 2007
 */
public class ExamplesRatGame{
  public ExamplesRatGame() {}

  /** the <code>{@link Rat Rat}</code> 
   * in the <code>{@link RatWorld RatWorld}</code> */
  Rat john = new Rat("John", new Posn(50, 50), 8);
  
  /** the only <code>{@link Food Food}</code> morsel 
   * in the <code>{@link RatWorld RatWorld}</code> */
  Food food1 = new Food(new Posn(20, 90), 2);

  /** the first sample <code>{@link Canvas Canvas}</code> 
   * to just show and draw into */
  Canvas c1 = new Canvas(200, 400);

  /** the second sample <code>{@link Canvas Canvas}</code> 
   * to just show and draw into */
  Canvas c2 = new Canvas(300, 200);
  
  /**
   * <p>Show both canvases, then draw into the first one.</p>
   * <p>Note that they overlap - drag one away to see the other.</p>
   * @return <code>true</code>
   */
  public boolean showCanvas(){
    this.c1.show();
    this.c2.show();
    return this.john.draw(this.c1) &&
           this.food1.draw(this.c1);
  }

  /** make a new <code>{@link RatWorld RatWorld}</code> */
  RatWorld mw = new RatWorld(this.john, this.food1);
 
  /**
   * Helper method to display a message and await RETURN before proceeding
   * @param message the message to display
   */
  public static void nextStep(String message){
    try{
      System.out.println(message);
      System.out.println("Press RETURN");     
      // no input needed - the default input is a valid integer
      int n = System.in.read();
    }
    catch(IOException e){
      System.out.println("Next step");
    }
  }
  
  /**
   * <P>Display all data defined in this class.</P>
   * <P>Run all tests defined in this class.</P>
   */
  public static void main(String[] argv){ 
    ExamplesRatGame e = new ExamplesRatGame();
    
    /** tests for the standalone <code>{@link Canvas Canvas}</code> behavior. */
    System.out.println("Canvas Test");
    nextStep("Two canvases should show - the first with a food and a rat");
    e.showCanvas();
    
    nextStep("Two more disks will be drawn (red and blue)");
    e.c1.drawDisk(new Posn(80, 40), 30, new Red());
    e.c1.drawDisk(new Posn(40, 80), 30, new Blue());
 
    nextStep("One green disks will be drawn in the second canvas");
    e.c2.drawDisk(new Posn(80, 40), 30, new Green());

    nextStep("The first canvas will close");   
    e.c1.close();
    
    nextStep("The first canvas will be shown again - with a black disk");   
    e.c1.show();
    e.c1.drawDisk(new Posn(50, 50), 30, new Black());
    
    /** a sample run of the <code>{@link RatWorld RatWorld}</code> */
    nextStep("Now run the Rat world");
    e.mw.go(0.5);
    
    System.out.println("After the world ends " + 
        "close all windows to end the program");      
  }

}