// to represent a song
class Song implements IsSame<Song>{
	String title;
	String artist;
	int duration;  // in minutes
	
	Song(String title, String artist, int duration){
		this.title = title;
		this.artist = artist;
		this.duration = duration;
	}
	
	/* TEMPLATE
	 * ... this.title ...       -- String
	 * ... this.artist ...      -- String
	 * ... this.duration ...    -- int
	 * 
	 * ... this.size() ...        -- boolean
	 * ... this.isSame(Song) ...  -- boolean
	 */
	
	// compute the value of this song - determined by its duration
	public int value(){
		return this.duration;
	}

	// is this song the same as the given song?
	public boolean isSame(Song that){
		return this.title.equals(that.title) &&
		       this.artist.equals(that.artist) &&
		       this.duration == that.duration;
	}
}