// to represent an image
class Image implements IsSame<Image>{
	String title;
	String fileType;
	int fileSize;  // in bytes
	
	Image(String title, String fileType, int fileSize){
		this.title = title;
		this.fileType = fileType;
		this.fileSize = fileSize;
	}
	
	/* TEMPLATE
	 * ... this.title ...       -- String
	 * ... this.fileType ...    -- String
	 * ... this.fileSize ...    -- int
	 * 
	 * ... this.size() ...        -- boolean
	 * ... this.isSame(Image) ... -- boolean
	 */
	
	// compute the value of this song - determined by its file size
	public int value(){
		return this.fileSize;
	}


	// is this image the same as the given image?
	public boolean isSame(Image that){
		return this.title.equals(that.title) &&
		       this.fileType.equals(that.fileType) &&
		       this.fileSize == that.fileSize;
	}
}