import tester.*;

// a method to verify equality of this item and the given one
interface IsSame<T>{
	// is this data the same as the given data?
	boolean isSame(T t);
}

//a method to compute the value this item 
interface IValue<T>{
// compute the value of this data
int value();
}

// to represent a list of items of the type <T>
interface ILo<T>{
  
 // compute the total size of this list
  int size();
   
  // compute the total value of this list
  int totalValue();
  
  // does this list contain the given item?
  boolean contains(T t);
}                                

// to represent an empty list of books
class MtLo<T> implements ILo<T>{
  MtLo(){}
  
  // compute the total size of this list
  public int size(){
  	return 0;
  }
   
  // compute the total value of this list
  public int totalValue(){
    return 0;
  }
  
  // does this list of books contain the given book?
  public boolean contains(T b){
  	return false;
  }
}                                              

// to represent a nonempty list of books
class ConsLo<T> implements ILo<T>{
  T first;
  ILo<T> rest;
  
  ConsLo(T first, ILo<T> rest){
    this.first = first;
    this.rest = rest;
  }
  

/* TEMPLATE:
   FIELDS:
    ... this.first ...              -- <T>
    ... this.rest ...               -- ILo<T>

    METHODS FOR FIELDS:
    ... this.rest.size() ...         -- int
    ... this.rest.contains(T) ...    -- boolean

*/
  
  // compute the total size of this list
  public int size(){
    return 1 + this.rest.size();
  }
   
  // compute the total value of this list
  public int totalValue(){
    return ((IValue<T>)this.first).value() + this.rest.totalValue();
  }
  
  // does this list contain the given item?
  public boolean contains(T t){
  	return ((IsSame<T>)this.first).isSame(t) ||
  	       this.rest.contains(t);
  }
}                                                    

