/**
 * CSU213 Spring 2009, Lab 12
 * Sorter class - contains wrappers for sorting algorithms
 */

import java.util.ArrayList;
import java.util.Comparator;


/**
 * Wrapper class for sorters
 */
public abstract class Sorter
{
   String name;
   Algorithms algo = new Algorithms();

   /**
    * @param n name of the sorter
    */
   Sorter(String n) { name = n; }
   
   /**
    * @param list <code>ArrayList</code> to be sorted
    * @param comp <code>Comparator</code> to use during sorting
    */
   abstract void sort(ArrayList<Integer> list, Comparator<Integer> comp);
}

/**
 * Wrapper class for selection sorter
 */
class Select extends Sorter
{
  Select() { super( "select" ); }
  
  /**
   * @param list <code>ArrayList</code> to be sorted
   * @param comp <code>Comparator</code> to use during sorting
   */
  void sort(ArrayList<Integer> list, Comparator<Integer> comp)
  {
    algo.selectionSort( list, comp );
  }
}

/**
 * Wrapper class for insertion sorter
 */
class Insert extends Sorter
{
   Insert() { super( "insert" ); }
   
   /**
    * @param list <code>ArrayList</code> to be sorted
    * @param comp <code>Comparator</code> to use during sorting
    */
   void sort(ArrayList<Integer> list, Comparator<Integer> comp)
   { 
       algo.insertionSort( list, comp );
   }
}

// ADD WRAPPERS FOR ADDITIONAL SORTERS HERE

