/**
 * CSU213 Spring 2009, Lab 12
 * Node class of IBST
 */

import java.util.Comparator;
import java.util.ArrayList;


// represents a node in a binary search tree
public class Node<T> implements IBST<T>
{
  Comparator<T> comp;
  T val;
  IBST<T> left;
  IBST<T> right;
  
  /**
   * @param val element at root of tree
   * @param left left subtree
   * @param right right subtree
   * @param comp elements in the tree are arranged by this 
   *        <code>Comparator</code>
   */
  Node(T val,IBST<T> left,IBST<T> right,Comparator<T> comp)
  {
    this.val = val;
    this.left = left;
    this.right = right;
    this.comp = comp;
  }
  
  /**
   * Adds an element to the tree and returns the new tree
   * 
   * @param t item to add
   * @return new tree containing added item
   */
  public IBST<T> add(T t)
  {
    if ( comp.compare( t, this.val ) < 0 ) {
      return new Node<T>( val, left.add( t ), right, comp );
    } else {
      return new Node<T>( val, left, right.add( t ), comp );
    }
  }

  /**
   * Adds all the elements in an <code>ArrayList</code> to the tree and 
   * returns the new tree
   * 
   * @param arr items to be added
   * @return new tree containing added items
   */
  public IBST<T> addAll(ArrayList<T> arr)
  {
    IBST<T> tree = this;
    
    for ( T t: arr ) {
      tree = tree.add( t );
    }
    
    return tree;
  }

  /**
   * Returns the smallest element of the tree
   * 
   * @return smallest element of the tree
   */
  public T getFirst()
  {
    if ( left.isLeaf() )
      return val;
    else
      return left.getFirst();
  }
  
  /**
   * Returns a tree with the smallest element removed from the tree
   * 
   * @return tree with smallest element removed
   */
  public IBST<T> getRest()
  {
    if ( left.isLeaf() )
      return right;
    else
      return new Node<T>( val, left.getRest(), right, comp );
  }
  
  /**
   * @return false because this is not a Leaf
   */
  public boolean isLeaf()
  {
    return false;
  }
  
  /**
   * Returns the elements of the tree in ascending order
   * 
   * @return elements of the tree in ascending order
   */
  public ArrayList<T> getContentsInOrder()
  {
    ArrayList<T> arr = new ArrayList<T>();

    // IMPLEMENTATION GOES HERE

    return arr;
  }
}
