/**
 * CSU213 Spring 2009, Lab 12
 * Leaf class of IBST
 */

import java.util.ArrayList;
import java.util.Comparator;


/**
 * represents an empty binary search tree
 * @param <T> type of element in tree
 */
public class Leaf<T> implements IBST<T>
{
  Comparator<T> comp;
  
  Leaf(Comparator<T> comp)
  {
    this.comp = comp;
  }
  
  /**
   * Creates a tree of 1 element
   */
  public IBST<T> add(T t)
  {
    return new Node<T>( t, this, this, this.comp ); 
  }
  
  /**
   * Adds all the elements in an <code>ArrayList</code> to the tree and 
   * returns the new tree
   * 
   * @param arr items to be added
   * @return new tree containing added items
   */
  public IBST<T> addAll(ArrayList<T> arr)
  {
    IBST<T> tree = this;
    
    for ( T t: arr ) {
      tree = tree.add( t );
    }
    
    return tree;
  }

  /**
   * Invalid to call this method on a Leaf
   */
  public T getFirst()
  {
    throw new RuntimeException( "Can't get first of Leaf" );    
  }
  
  /**
   * Invalid to call this method on a Leaf
   */
  public IBST<T> getRest()
  {
    throw new RuntimeException( "Can't get rest of Leaf" );    
  }

  /**
   * @return true because this is a leaf
   */
  public boolean isLeaf()
  {
    return true;
  }

  /**
   * @return empty <code>ArrayList</code>
   */
  public ArrayList<T> getContentsInOrder()
  {
    return new ArrayList<T>();
  }
}
