/**
 * CSU213 Spring 2009, Lab 12
 * IBST interface - A simple BST interface
 */

import java.util.ArrayList;


/**
 * Interface for a binary search tree

 * @param <T> type of elements in the tree
 */
public interface IBST<T>
{
  /**
   * Adds an element to the tree and returns the new tree
   * 
   * @param t item to add
   * @return new tree containing added item
   */
  IBST<T> add(T t);
  
  /**
   * Adds all the elements in an <code>ArrayList</code> to the tree and 
   * returns the new tree
   * 
   * @param arr items to be added
   * @return new tree containing added items
   */
  IBST<T> addAll(ArrayList<T> arr);

  /**
   * Returns the smallest element of the tree
   * 
   * @return smallest element of the tree
   */
  T getFirst();
  
  /**
   * Returns a tree with the smallest element removed from the tree
   * 
   * @return tree with smallest element removed
   */
  IBST<T> getRest();
  
  /**
   * Indicates whether tree is a leaf (ie - ie empty)
   * 
   * @return returns true if the tree is a leaf
   */
  boolean isLeaf();
  
  /**
   * Returns the elements of the tree in ascending order
   * 
   * @return elements of the tree in ascending order
   */
  ArrayList<T> getContentsInOrder();
}
