/**
 * CSU213 Spring 2009, Lab 12
 * Examples class
 */

import tester.*;
import java.util.ArrayList;
import java.util.Comparator;


/**
 * Contains test methods to be run by Tester 
 */
public class Examples
{
  Algorithms algo = new Algorithms();
  Comparator<Integer> comp = new IntComp();
 
  /**
   * Wrapper for System.out.println
   * 
   * @param s string to be printed
   */
  void println(String s)
  {
    print( s + '\n' );
  }
  /**
   * Wrapper for System.out.print
   * 
   * @param s string to be printed
   */
  void print(String s)
  {
    System.out.print( s );
  }

  /**
   * Return a random Integer between: [0, max)
   * 
   * @param max maximum possible random number that can be generated
   * @return random Integer
   */
  Integer randomInt(int max)
  {
    return new Integer( algo.randInt( 0, max ) );
  }
    
  /**
   * Returns an ArrayList of the specified size that is filled with random 
   * Integers between 0 and max (exclusive)
   * 
   * @param size number of random <code>Integer</code>s to generate
   * @param max maximum possible generated value
   * @return <code>ArrayList</code> containing randomly generated
   *         <code>Integer</code>s
   */
  ArrayList<Integer> genRandArrayList(int size, int max)
  {
      ArrayList<Integer> list = new ArrayList<Integer>( size );
      for ( int i = 0; i < size; i++ )
          list.add( randomInt( max ) );
      return list;
  }

  /**************************************************************************
   * Visual test of sorters - outputs contents of <code>ArrayList</code>
   * before and after sorting
   * 
   * @param t <code>Tester object</code>
   **************************************************************************/
  void testSortersVisual(Tester t)
  {
    // Easy visual sort tests
    visualTest( new Insert(), comp );
    visualTest( new Select(), comp );
    // ADD TEST FOR ADDITIONAL SORTERS HERE
  }

  /**
   * Helper method used by testSortersVisual.
   * Helps programmer make visual check of the sorter methods
   * 
   * @param sorter sorter to be tested
   * @param comp <code>Comparator</code> to use during sorting
   */
  void visualTest(Sorter sorter, Comparator<Integer> comp)
  {        
    ArrayList<Integer> list = genRandArrayList( 10, 40 );
    println("       Unsorted\t: " + list );
    sorter.sort( list, comp );
    println( "Sorted(" + sorter.name + ")\t: " + list );
  }

  /**************************************************************************
   * Actual test of sorters - verifies that <code>ArrayList</code> is sorted
   * after applying sorting algorithm
   * 
   * @param t <code>Tester</code> object
   **************************************************************************/
  void testSorters(Tester t)
  {
    // UNCOMMENT ME
//    t.checkExpect( isSorterWorking( new Insert() ), true );
//    t.checkExpect( isSorterWorking( new Select() ), true );
    // ADD TEST FOR ADDITIONAL SORTERS HERE
  }
  

  /**
   * Helper method used by testSorters
   * Tests the given sorter on an array of random data.
   * 
   * @param s sorter to test
   * @return true if sorter correctly sorts randomly generated data
   */
  boolean isSorterWorking(Sorter s)
  {
    ArrayList<Integer> arr = genRandArrayList( 1000, 1000 );
    s.sort( arr, comp );
    return isSorted( arr, comp );
  }
  
  /**
   * Indicates whether the given <code>ArrayList</code> is sorted according 
   * to the given <code>Comparator</code>
   * 
   * @param <T> type of an element in the <code>ArrayList</code>
   * @param list contains sorted elements
   * @param comp <code>Comparator</code> to use when testing for sortedness
   * @return true if given <code>ArrayList</code> is sorted
   */
  <T> boolean isSorted(ArrayList<T> list, Comparator<T> comp)
  {
    // IMPLEMENTATION GOES HERE
    
    return false;
  }
    
  /**************************************************************************
   * Test timing of sorters
   * 
   * @param t <code>Tester</code> object
   **************************************************************************/
  void testSorterTiming(Tester t)
  {
    ArrayList<Sorter> sorters = new ArrayList<Sorter>();
    
    sorters.add( new Insert() );
    sorters.add( new Select() );
    // ADD ADDITIONAL SORTERS HERE
    
    // UNCOMMENT ME
//    runTimedSortTest( sorters, new SortTestRandom() );
//    runTimedSortTest( sorters, new SortTestSorted() );
//    runTimedSortTest( sorters, new SortTestReversed() );
  } // end test()
  
  /**
   * Helper method used by testSorterTiming
   * 
   * @param sorters <code>ArrayList</code> of sorters
   * @param test type of data to use for test (ie - random, sorted, etc)
   */
  void runTimedSortTest(ArrayList<Sorter> sorters, TimedSortTest test)
  {
    int loops = 4;
    int runs = 100;
    int size = 128;
    
    // Print out the Timings for each of the sorts in a kind of table
    println( "\nTimings (" + test.name + " data) (ms):" );
    print( "N" );
    for ( Sorter sorter: sorters )
      print( "\t" + sorter.name );
    print( "\n" );

    for ( int i = 0; i < loops; i++ ) {
      print( size + "\t" );
      for ( Sorter sorter: sorters ) {
        print( test.getSortTime( sorter, runs, size, comp ) + "\t" );
      }
      size *= 2;
      print( "\n" );
    }
  }
  
  /**
   * Abstract class used for different timed sorting tests
   */
  abstract class TimedSortTest
  {
    String name;

    /**
     * @param name name of the test
     */
    TimedSortTest(String name) { this.name = name; }
    
    /**
     * Runs a sorting test "runs" number of times on an <code>ArrayList</code>
     * of size "size" using sorter and comp returns the time of the test in 
     * milliseconds
     * 
     * @param sorter sorter to use for test - selection, insertion, etc
     * @param runs Number of times to repeat the test. A fresh data set will
     *        generated for each run
     * @param size Size of the dataset used on each run
     * @param comp <code>Comparator</code> used for sorting
     * @return total time of all the runs, in milliseconds
     */
    abstract long getSortTime(Sorter sorter, int runs, int size, Comparator<Integer> comp);
  }
  
  /**
   * Tests sorting on random data
   */
  class SortTestRandom extends TimedSortTest
  {
    SortTestRandom() { super( "Random" ); };
    
    /**
     * Tests sorting on random data
     * 
     * @param sorter sorter to use for test - selection, insertion, etc
     * @param runs Number of times to repeat the test. A fresh data set will
     *        generated for each run
     * @param size Size of the dataset used on each run
     * @param comp <code>Comparator</code> used for sorting
     * @return total time of all the runs, in milliseconds
     */
    long getSortTime(Sorter sorter, int runs, int size, Comparator<Integer> comp)
    {
      ArrayList<ArrayList<Integer>> datas = new ArrayList<ArrayList<Integer>>();
      Timing timer = new Timing();
      
      for ( int i = 0; i < runs; i++ ) {
        datas.add( genRandArrayList( size, 1000 ) );
      }
      timer.start();
      for ( ArrayList<Integer> list: datas ) {
        sorter.sort( list, comp );
      }
      return timer.stop();
    }
  }
  
  /**
   * Tests sorting on data that is already sorted
   */
  class SortTestSorted extends TimedSortTest
  {
    SortTestSorted() { super( "Sorted" ); };

    /**
     * Tests sorting on data that is already sorted
     * 
     * @param sorter sorter to use for test - selection, insertion, etc
     * @param runs Number of times to repeat the test. A fresh data set will
     *        generated for each run
     * @param size Size of the dataset used on each run
     * @param comp <code>Comparator</code> used for sorting
     * @return total time of all the runs, in milliseconds
     */
    long getSortTime(Sorter sorter, int runs, int size, Comparator<Integer> comp)
    {
      ArrayList<ArrayList<Integer>> datas = new ArrayList<ArrayList<Integer>>();
      Timing timer = new Timing();
      
      for ( int i = 0; i < runs; i++ ) {
        ArrayList<Integer> list = genRandArrayList( size, 1000 );
        sorter.sort( list, comp );
        datas.add( list );
      }
      timer.start();
      for ( ArrayList<Integer> list: datas ) {
        sorter.sort( list, comp );
      }
      return timer.stop();
    }
  }
  
  /**
   * Tests sorting on data that is in reverse-sorted order
   */
  class SortTestReversed extends TimedSortTest
  {
    SortTestReversed() { super( "Reversed" ); }
    
    /**
     * Tests sorting on data that is in reverse-sorted order
     *  
     * @param sorter sorter to use for test - selection, insertion, etc
     * @param runs Number of times to repeat the test. A fresh data set will
     *        generated for each run
     * @param size Size of the dataset used on each run
     * @param comp <code>Comparator</code> used for sorting
     * @return total time of all the runs, in milliseconds
     */
    long getSortTime(Sorter sorter, int runs, int size, Comparator<Integer> comp)
    {
      ArrayList<ArrayList<Integer>> datas = new ArrayList<ArrayList<Integer>>();
      Timing timer = new Timing();
      
      for ( int i = 0; i < runs; i++ ) {
        ArrayList<Integer> list = genRandArrayList( size, 1000 );
        sorter.sort( list, comp );
        reverse( list );
        datas.add( list );
      }
      timer.start();
      for ( ArrayList<Integer> list: datas ) {
        sorter.sort( list, comp );
      }
      return timer.stop();
    }

    /**
     * Reverse the elements in an <code>ArrayList</code>
     * 
     * @param <T> type of elements in <code>ArrayList</code>
     * @param list
     */
    <T> void reverse(ArrayList<T> list)
    {
      int start = 0, end = list.size() - 1;
      while ( start < end ) {
        algo.swap( list, start, end );
        start++;
        end--;
      }
    }
  }
}
