/**
 * CSU213 Spring 2009, Lab 12
 * Algorithms class
 */

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;

/**
 * Class containing sorting algorithms
 */
public class Algorithms
{
  /**
   * Return random Integer between: [low, high)
   * 
   * @param low low end of the range (inclusive)
   * @param high high end of the range (exclusive)
   * @return random Integer
   */
  public Integer randInt(int low, int high)
  { 
    return new Random().nextInt( high - low ) + low; 
  }
  
  /**
   * The swap we've seen many times in previous labs/hws
   * 
   * @param list list containing elements to be swapped
   * @param i item to be swapped
   * @param j item to be swapped
   */
  <T> void swap(ArrayList<T> list, int i, int j)
  {
     list.set( i, list.set( j, list.get( i ) ) );
  }
    
  /**
   * selection sort algorithm - continually finds min element and swaps it into place
   * 
   * @param list list to be sorted
   * @param comp <code>Comparator</code> to use for compares during sorting
   */
  public <T> void selectionSort(ArrayList<T> list, Comparator<T> comp)
  {
    int limit = list.size();
    for ( int index = 0; index < limit; index = index + 1 ) {
      swap( list, index, findMinIndex( list, comp, index ) );
    }
  }
    
  /**
   *  Find the index of the minimum element in the ArrayList of all elements 
   *  after index low.
   *  Can assume it is not empty and low is a valid index.
   *  
   * @param list 
   * @param comp <code>Comparator</code> to use for finding min
   * @param low starting index
   * @return index of min element
   */
  <T> int findMinIndex(ArrayList<T> list, Comparator<T> comp, int low)
  {
    int minindex = low;
    int limit = list.size();
    for ( int index = low; index < limit; index = index + 1 ) {
      if ( comp.compare( list.get( index ), list.get( minindex ) ) <= 0 )
        minindex = index;
    }
    return minindex;
  }

  /**
   * Basic insertion sort algorithm.
   * Starting from the back, insert the current element into the
   * sorted 'rest' of the list. The last element is trivially sorted.
   *   
   * @param list list to be sorted
   * @param comp <code>Comparator</code> to use for compares during sorting
   */
  public <T> void insertionSort(ArrayList<T> list, Comparator<T> comp)
  {
    for( int i = list.size() - 2; i >= 0; i-- )
      insert( list, i, comp );
  }
    
  /**
   * "inserts" an element at i into the sorted part of the <code>ArrayList</code>
   * 
   * Assumes <code>ArrayList</code> is sorted starting from the end
   * 
   * @param list list to do "insertion" on
   * @param i item to "insert"
   * @param comp <code>Comparator</code> to use for compares during insertion
   */
  <T> void insert(ArrayList<T> list, int i, Comparator<T> comp)
  {
    while( i < list.size() - 1 
             && 
           comp.compare( list.get( i + 1 ), 
                         list.get( i ) ) < 0 )
    {
      swap( list, i, i + 1 );
      i++;
    }
  }

  /**
   * Sorts given <code>ArrayList</code> using quicksort algorithm.
   * 
   * @param list list to be sorted
   * @param comp <code>Comparator</code> to use for compares during sorting
   */
  public <T> void quickSort(ArrayList<T> list, Comparator<T> comp)
  {
    // IMPLEMENTATION GOES HERE
  }

  /**
   * tree sort using a BST from previous hw
   * 
   * @param list list to be sorted
   * @param comp <code>Comparator</code> to use for compares during sorting
   */
  public <T> void treeSort213(ArrayList<T> list, Comparator<T> comp)
  {
    IBST<T> tree = new Leaf<T>( comp );
    tree = tree.addAll( list );
    list.clear();
    list.addAll( tree.getContentsInOrder() );
  }
}
