import tester.Traversal;

/**
 * Encapsulate a function that consumes a data item
 * and an accumulator and produces a new value of the accumulator
 */
interface ITS2S<T, S>{
  S update(T t, S s);
}

/**
 * Encapsulate three implementations of loops traversing over
 * a data set generated by the functional <code>Traversal</code>
 * iterator and performing accumulator update specified by the
 * <code>ITS2S</code> function object
 */
class ForEach<T, S>{
  S acc;
  ITS2S<T, S> apply;
  Traversal<T> tr;
  
  ForEach(S acc, ITS2S<T, S> apply, Traversal<T> tr){
    this.acc = acc;
    this.apply = apply;
    this.tr = tr;
  }
  
  S compute1(){
    if (tr.isEmpty())
      return acc;
    else
      return (new ForEach<T, S>(this.apply.update(tr.getFirst(), acc),
                         apply, tr.getRest())).compute1();
  }
  
  S compute2(){
    while (!tr.isEmpty()){
      acc = apply.update(tr.getFirst(), acc);
      tr = tr.getRest();
    }
    return acc;
  }
  
  S compute3(){
    for (; !tr.isEmpty(); tr = tr.getRest()){
      acc = apply.update(tr.getFirst(), acc);     
    }
    return acc;
  }
}

