import tester.*;
import java.util.*;

/**
 * to represent a nonempty list of objects
 */
class ArrListTraversal<T> implements Traversal<T>{

  ArrayList<T> arrlist;
  int current;

  /**
   * Public constructor for the <code>ArrayList</code> we wish to traverse
   * 
   * @param arrlist the <code>ArrayList</code> we wish to traverse
   */
  public ArrListTraversal(ArrayList<T> arrlist){
    if (arrlist == null) 
      throw new IllegalUseOfTraversalException(
      		"Cannot traverse a null ArrayList");
    this.arrlist = arrlist;
    this.current = 0;
  }
  
  /**
   * Private constructor to produce the <code>Traversal</code> for the 
   * rest of the <code>ArrayList</code> we are currently traversing
   * 
   * @param arrlist the <code>ArrayList</code> we are currently traversing
   * @param first the index for the first element to view in the given
   * <code>ArrayList</code>
   */
  private ArrListTraversal(ArrayList<T> arrlist, int current){
    this.arrlist = arrlist;
    this.current = current;
  }
  

  /**
   * Is this an empty list?
   */
  public boolean isEmpty(){ 
    return this.current == arrlist.size();
  }  

  /**
   * Produce the first item in this list
   */
  public T getFirst(){
    if (this.isEmpty())
      throw new IllegalUseOfTraversalException(
      		"No first element in an empty list");
    return this.arrlist.get(this.current);
  }

  /** 
   * Produce a <code>Traversal</code> for the rest of this list
   */
  public Traversal<T> getRest(){
    if (this.isEmpty())
      throw new IllegalUseOfTraversalException(
      		"No more elements in an empty list");
    return new ArrListTraversal<T>(this.arrlist, this.current + 1);
  }
} 
