import java.util.*;
import tester.*;

// a class to represent a node in a binary search tree
public class Node<T> extends ABST<T>{
	T data;
	ABST<T> left;
	ABST<T> right;

	Node(T data, ABST<T> left, ABST<T> right){
		super(left.comp);
		this.data = data;
		this.left = left;
		this.right = right;
	}
	
	// is this an empty tree (a leaf)?
	public boolean isEmpty(){
		return false;
	}
	
	// produce the smallest item in this tree
	public T getFirst(){
		return this.data;
	}
	
	// produce a binary search tree with the first node removed
	public Traversal<T> getRest(){
		return this.left;
	}	

	// insert the given data into this binary search tree
	public ABST<T> add(T data){
		if (comp.compare(data, this.data) <= 0)
		  return new Node<T>(this.data, this.left.add(data), this.right);
		else
			return new Node<T>(this.data, this.left, this.right.add(data));
	}

	// allow the visitor to perform tasks using the provided data
	public <R> R accept(ABSTvisitor<T, R> ask){
		return ask.forNode(this.data, this.left, this.right);
	}
}