import java.util.*;
import tester.*;

public class Leaf<T> extends ABST<T>{

	Leaf(Comparator<T> comp){
		super(comp);
	}
	
	// is this an empty tree (a leaf)?
	public boolean isEmpty(){
		return true;
	}
	
	// produce the smallest item in this tree
	public T getFirst(){
		throw new IllegalUseOfTraversalException("No first element in a leaf");
	}
	
	// produce a binary search tree with the first node removed
	public Traversal<T> getRest(){
		throw new IllegalUseOfTraversalException("No more elements in a leaf");
	}	
	
	// insert the given data into this binary search tree
	public ABST<T> add(T data){
		return new Node<T>(data, this, this);
	}

	// allow the visitor to perform tasks using the provided data
	public <R> R accept(ABSTvisitor<T, R> ask){
		return ask.forLeaf();
	}
}