import java.util.*;

import tester.*;

public class Examples{
	Examples(){}
	
	// PART 1: Books
	Book oms = new Book("Old Man and the Sea", "Hemingway", 20);
	Book eos = new Book("Elements of Style", "EBW", 15);
	Book htdp = new Book("HtDP", "MF", 60);
	Book ll = new Book("Little Lisper", "MF", 20); 

	// test the method toString for the class Book
	void testToStringBook(Tester t){
		t.checkExpect(oms.toString(), 
		"Book: Old Man and the Sea, by Hemingway, cost: $20\n");
		t.checkExpect(eos.toString(), 
		"Book: Elements of Style, by EBW, cost: $15\n");
		t.checkExpect(htdp.toString(), 
		"Book: HtDP, by MF, cost: $60\n");
		t.checkExpect(ll.toString(), 
		"Book: Little Lisper, by MF, cost: $20\n");	
	}

	Comparator<Book> booksByPrice = new Book.BookByPrice();

	ABST<Book> leaf = new Leaf<Book>(booksByPrice);
	ABST<Book> tree3 = new Node<Book>(htdp, 
			                        new Node<Book>(this.eos, this.leaf, this.leaf),
                              new Node<Book>(this.oms, this.leaf, this.leaf));
	ABST<Book> tree4 = tree3.add(ll);
	
	Algorithms a = new Algorithms();
	
	CountNodes<Book> countNodes = new CountNodes<Book>();
	
	// test the count method for binary search trees in the Algorithms class 
	void testCountAlgorithms(Tester t){
		t.checkExpect(a.countNodes(leaf), 0);
		t.checkExpect(a.countNodes(tree3), 3);
		t.checkExpect(a.countNodes(tree4), 4);
	}
	
	// test the visitor based count method for binary search trees 
	void testCountVisitor(Tester t){
		t.checkExpect(leaf.accept(countNodes), 0);
		t.checkExpect(tree3.accept(countNodes), 3);
		t.checkExpect(tree4.accept(countNodes), 4);
	}
}