import java.util.Comparator;

// to represent a book in a bookstore
class Book{
  String title;
  String author;
  int price;
  
  Book(String title, String author, int price){
    this.title = title;
    this.author = author;
    this.price = price;
  }
  
  public String toString(){
  	return "Book: " + this.title + ", by " + this.author + 
  	       ", cost: $" + this.price + "\n";
  }
  
	// compare the two accounts by their balance
	static class BookByTitle implements Comparator<Book>{
		//  does the title of the first book come before the title of the second?
		public int compare(Book one, Book two){
			return one.title.compareTo(two.title);
		}
	}

	//compare the two books by their price
	static class BookByPrice implements Comparator<Book>{
		// is the first book cheaper than the second one?
		public int compare(Book one, Book two){
			return one.price - two.price;
		}
	}
}