// a visitor for a binary searcht ree
public interface ABSTvisitor<T, R>{
	
	// perform the task for the leaf of the BST
	R forLeaf();
	
	// perform the task for the node of the BST
	R forNode(T data, ABST<T> left, ABST<T> right);
}

// count the nodes in the BST
class CountNodes<T> implements ABSTvisitor<T, Integer>{
	
	// perform the task for the leaf of the BST
	public Integer forLeaf(){
		return 0;
	}
	
	// perform the task for the node of the BST
	public Integer forNode(T data, ABST<T> left, ABST<T> right){
		return 1 + left.accept(this) + right.accept(this);
	}
}
