import java.util.*;
import tester.*;

// to represent an abstract binary search tree 
public abstract class ABST<T> implements Traversal<T>{
	// the comparator that determines the tree ordering
	protected Comparator<T> comp;
	
	public ABST(Comparator<T> comp){
		this.comp = comp;
	}

	// allow the visitor to perform tasks using the provided data
	abstract public <R> R accept(ABSTvisitor<T, R> ask);
	
	// insert the given data into this binary search tree
	abstract public ABST<T> add(T data);
}