// to represent a list of items
public interface ILo<T>{
  
	// produce a list that contains only elements 
	// for which choose.pick() returns true.
	public ILo<T> filter(ISelector<T> choose);

	// determine if choose.pick() returns true for every element in the list.
	public boolean andMap(ISelector<T> choose);

  // determine if choose.pick() returns true for one or more elements
	// in the list.
	public boolean orMap(ISelector<T> choose);

	// sum the cost of all elements in the list, where the cost is determined
	// by cost.value()
	public int totalCost(IValue<T> cost);
  
  // apply the update to combine every item in the list 
  // with the accumulated value, starting with the base value
	<R> R fold(IFunTR2R<T, R> update, R base);
}                                
