import tester.*;

class ExamplesLists{
	ExamplesLists(){}

  Book oms = new Book("Old Man and the Sea", "Hemingway", 20);
  Book eos = new Book("Elements of Style", "EBW", 15);
  Book htdp = new Book("HtDP", "MF", 60);
  Book ll = new Book("Little Lisper", "MF", 20);
  
  ILo<Book> mtlob = new MtLo<Book>();
  ILo<Book> blist2 = new ConsLo<Book>(this.oms, 
  		               new ConsLo<Book>(this.eos, this.mtlob));
  ILo<Book> blist3 = new ConsLo<Book>(this.htdp, this.blist2);
  ILo<Book> blist4 = new ConsLo<Book>(this.htdp, this.mtlob);
  
  ISelector<Book> ch25= new CheapBook(25);
  
  // test the method filter for the classes that represent a list of items
  void testFilter(Tester t){
  	t.checkExpect(mtlob.filter(ch25), mtlob);
  	t.checkExpect(blist2.filter(ch25), blist2);
  	t.checkExpect(blist3.filter(ch25), blist2);
  }
 
  // test the method orMap for the classes that represent a list of items
  void testOrMap(Tester t){
  	t.checkExpect(mtlob.orMap(ch25), false);
  	t.checkExpect(blist2.orMap(ch25), true);
  	t.checkExpect(blist4.orMap(ch25), false);
  }
 
  // test the method andMap for the classes that represent a list of items
  void testAndMap(Tester t){
  	t.checkExpect(mtlob.andMap(ch25), true);
  	t.checkExpect(blist2.andMap(ch25), true);
  	t.checkExpect(blist3.andMap(ch25), false);
  }
}

