
// to represent a nonempty list of items
public class ConsLo<T> implements ILo<T>{
  T first;
  ILo<T> rest;
  
  ConsLo(T first, ILo<T> rest){
    this.first = first;
    this.rest = rest;
  }
  
	// produce a list that contains only elements 
	// for which choose.pick() returns true.  
	public ILo<T> filter(ISelector<T> choose){
		if (choose.pick(this.first))
			return new ConsLo<T>(this.first, this.rest.filter(choose));
		return this.rest.filter(choose);
	}

	// determine if choose.pick() returns true for every element in the list.
	public boolean andMap(ISelector<T> choose) {
		return (choose.pick(this.first)) &&
			this.rest.andMap(choose);
	}

  // determine if choose.pick() returns true for one or more elements
	// in the list.
	public boolean orMap(ISelector<T> choose) {
		return (choose.pick(this.first)) ||
			this.rest.orMap(choose);
	}

	// sum the cost of all elements in the list, where the cost is determined
	// by cost.value()
	public int totalCost(IValue<T> cost) {
		return cost.value(this.first) +
			this.rest.totalCost(cost);
	}
	
  // apply the update to combine every item in the list 
  // with the accumulated value, starting with the base value
	public <R> R fold(IFunTR2R<T, R> update, R base){
		return update.combine(this.first,
					                this.rest.fold(update, base));
	}
}                                                    
