import tester.*;
import geometry.Posn;


//-----------------------------------------------------------------------------
//examples
public class Examples implements IExamples{
  public Examples(){};
  // examples of data for the Blob class:
  Blob b1 = new Blob(new Posn(100, 100), 50);
  Blob b2 = b1.moveBlob("left");


  // test the method moveBlob
  void testMoveBlob(Tester t){ 
    t.checkExpect(b1.moveBlob("left"), (new Blob(new Posn(95, 100), 50)),
        "test moveBolb - left " + "\n");
    t.checkExpect(b1.moveBlob("right"), (new Blob(new Posn(105, 100), 50)),
        "test movelob - right " + "\n");
    t.checkExpect(b1.moveBlob("up"), (new Blob(new Posn(100, 95), 50)),
        "test moveBlob - up " + "\n");
    t.checkExpect(b1.moveBlob("down"), (new Blob(new Posn(100, 105), 50)),
        "test moveBlob - down " + "\n");  
  }

  // test the method outsideBounds
  void testOutsideBounds(Tester t){
    t.checkExpect(b1.outsideBounds(60, 200), true,
        "test testOutsideBounds "+ "\n");
    t.checkExpect(b1.outsideBounds(100, 90), true,
        "test testOutsideBounds "+ "\n");
    t.checkExpect(new Blob(new Posn(-5, 100), 50).outsideBounds(100, 110), true,
        "test testOutsideBounds "+ "\n");
    t.checkExpect(new Blob(new Posn(80, -5), 50).outsideBounds(100, 90), true,
        "test testOutsideBounds " + "\n");
    t.checkExpect(b1.outsideBounds(200, 400), false,
        "test testOutsideBounds "+ "\n");
  }

  // combine all tests
  public void tests(Tester t){ 
    testMoveBlob(t);
    testOutsideBounds(t);
    t.checkExpect(runWorld(), true, "run program, run");
  }

  // start the world 
  boolean runWorld(){
    // construct an instance of a TimerWorld
    TimerWorld w = new TimerWorld(new Blob(new Posn(100, 200), 20));
    // and run the TimerWorld
    return w.bigBang(200, 400, 0.3);
  }
  
 
}